<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Ads;
use Hash;
use DB;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Str;
use Mail;
use App\Http\Traits\AccountTraits;


class AccountController extends Controller
{

    use AccountTraits ;

    public function getAccountList(Request $request)
    {
        $getUsers =  $this->getAllUser();
        $getDynamicFields = getIndexFields(Request(),'accounts');
        return view('accounts.index')->with(['accounts' => $getUsers,"fields_name" => $getDynamicFields]);
    }

    public function addAccount(Request $request)
    {

        $validate = $request->validate([
            'email' => "required",
            'password' => "required",
            'firstname' => "required",
            'lastname' => "required",
        ]);

        extract($request->all());

        $check_email = User::where('email', $email)->first();
        if ($check_email) {
            return back()->with(array('error' => "Email id already exists"));
        }

        $request->merge(['password' => Hash::make($request->password)]);

        $addAccount = $this->createAccount($request);

        if($addAccount){
            return back()->with(["success" => config('globalMessages.account_create_success') ]);
        }else{
            return back()->with(["error" => config('globalMessages.account_create_error')]);
        }
    }

    public function editAccount(Request $request): \Illuminate\Http\RedirectResponse
    {

        extract($request->all());

        $updateAccount = $this->editAccout($request);
        if($updateAccount){
            return back()->with(["success" => config('globalMessages.account_update_success')]);
        }else{
            return back()->with(["error" => config('globalMessages.account_update_error') ]);
        }

    }




}
