<?php
namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Ads;
use App\Models\User;
use App\Models\AdsClick;
use Illuminate\Support\Facades\Validator;
use DB;
use App\Http\Traits\AdsTraits;

class AdsController extends Controller
{
    use AdsTraits;

    public function adsList()
    {
        $ads = $this->selectAllAds();
        return response()->json(["status" => "success", "message" => "Ads list", "ads" => $ads]);
    }

    public function getAdsDetails($app_name,$ads_id)
    {
        $getAds = $this->getAdsDetail($ads_id);
        if($getAds){
            return response()->json(["status" => "success","message" => config('globalMessages.get_ads_detail_success'), "data" => $getAds]);
        }else{
            return response()->json(["status" => "error", "message" => config('globalMessages.get_ads_detail_error')]);
        }
    }

    public function deleteAds(Request $request)
    {
        $getAds = $this->adsDelete($request);
        if($getAds){
            return response()->json(["status" => "success", "message" => config('globalMessages.ads_deleted_success')]);
        }else{
            return response()->json(["status" => "error", "message" => config('globalMessages.get_ads_detail_error')]);
        }
    }

    public function adsclick(Request $request)
    {
        $res = array();

        $validator = Validator::make($request->all(), [
            "user_id" =>  "required",
            "ads_id"    =>  "required"
        ]);

        if ($validator->fails()) {
            $messages = $validator->messages();
            $return_message = array();
            foreach ($messages->getmessages() as $key => $message) {
                $return_message[] = implode(",", $message);
            };
            $response['status'] = 'error';
            $response['message'] = implode(",", $return_message);
            return $response;
        }

        $inputs = $request->all();
        extract($inputs);

        $user_id = $request->get('user_id');
        $ads_id = $request->get('ads_id');

        $user = User::find($user_id);
        if ($user) {
            $ads = Ads::find($ads_id);
            if ($ads) {
                $ads->image_path = env('APP_URL') . '/' . $ads->image_path;
                $ads_clicks = new AdsClick();
                $ads_clicks->ads_id = $ads_id;
                $ads_clicks->user_id = $user_id;
                if ($ads_clicks->save()) {
                    $res['status'] = 'success';
                    $res['message'] = 'Ad click added successfull.';

                    $res['ads'] = $ads;
                } else {
                    $res['status'] = 'error';
                    $res['message'] = 'Click not added.';
                    $res['ads'] = $ads;
                }
            } else {
                $res['status'] = 'error';
                $res['message'] = 'Ad not found.';
            }
        } else {
            $res['status'] = 'error';
            $res['message'] = 'User nor found.';
        }
        return $res;
    }


}
