<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Event;
use App\Models\EventCategory;
use DB;
use App\Http\Traits\EventTraits;

class EventController extends Controller
{
    use EventTraits;

    public function getEventList(Request $request)
    {
        $events =  $this->getAllEvent();
        foreach ($events as $new_event) {
            if(isset($new_event->category_id)){
                $categoryName = EventCategory::where('id', $new_event->category_id)->first();
                if ($categoryName) {
                    $new_event->category_name = $categoryName->name;
                } else {
                    $new_event->category_name = "None";
                }
            }
            
        }
        if(isset($new_event->category_id)){
            $category = EventCategory::orderBy('order_num', 'DESC')->get();
        }else{
            $category = [];
        }
        
        $getDynamicFields = getIndexFields(Request(),'events');
        return view('event.index')->with(['events' => $events,'category'=>$category,"fields_name"=>$getDynamicFields]);
    }

    public function addEvent(Request $request)
    {
        $request->validate([
            'image' => "required|image|mimes:jpeg,png,jpg,gif,svg",
            'title' => "required",
            'start_end_time' => "required",
        ]);

        extract($request->all());

        if ($request->hasFile('image')) {

            $image_path = storeImage($request,$request->image,'events');
        } else {
            $image_path = '';
        }

        $start_date = date('Y-m-d H:i:s');
        $end_date = date('Y-m-d H:i:s');
        if ($request->get('start_end_time') != '') {
            $export_text2 = explode("-", $request->get('start_end_time'));
            $start_date = $export_text2[0];
            $end_date = $export_text2[1];
        }

        $request->merge(['image_path'=>$image_path,'start_date' => date('Y-m-d H:i:s', strtotime($start_date))
                        ,'end_date' => date('Y-m-d H:i:s', strtotime($end_date))]);

        $addEvent = $this->createEvent($request);
        if($addEvent){
            return back()->with(["success" => config('globalMessages.event_create_success') ]);
        }else{
            return back()->with(["error" => config('globalMessages.event_create_error')]);
        }
    }

    public function editEvent(Request $request): \Illuminate\Http\RedirectResponse
    {
        $request->validate([
            'title' => "required",
            'start_end_time' => "required",
        ]);

        extract($request->all());
        $event_id = $request->get('event_id');

        $arr = $request->all();
        unset($arr['_token']);
        unset($arr['event_id']);

        $currentImagePath = $this->getImagePath($event_id);
        $image_path = "";
        if ($request->hasFile('image')) {

            $image_path = storeImage($request,$request->image,'events');

        } else {
            $image_path = '';
        }

        $export_date = explode("-", $request->post('start_end_time'));
        $start_date = $export_date[0];
        $end_date = $export_date[1];

        $arr = array_merge($arr,['start_date' => date('Y-m-d H:i:s', strtotime($start_date))
        ,'end_date' => date('Y-m-d H:i:s', strtotime($end_date))]);

        if($image_path != ""){
            $arr = array_merge($arr,['image_path'=>$image_path]);
        }
        unset($arr['image']);
        unset($arr['start_end_time']);

        $checkEvent = $this->updateEvents($event_id,$arr);
        if($checkEvent){

            if ($image_path != '' && $currentImagePath !== "") {
                if(file_exists($currentImagePath)){
                    unlink($currentImagePath);
                }
            }

            return back()->with(["success" => config('globalMessages.event_update_success')]);
        }else{
            return back()->with(["error" => config('globalMessages.event_update_error') ]);
        }
    }



}
