<?php
namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\NewsBlogs;
use DB;
use App\Http\Traits\NewsBlogsTraits;


class NewsBlogsController extends Controller
{
    use NewsBlogsTraits ;

    public function getNewsBlogsList(Request $request)
    {
        $getnews = $this->getNewsBlogs();

        $getDynamicFields = getIndexFields(Request(),'news_blogs');

        return view('news_blogs.index')->with(['getnews'=>$getnews,'fields_name'=>$getDynamicFields]);
    }

    public function addNewsBlogs(Request $request)
    {
        $request->validate([
            'image' => "required|image|mimes:jpeg,png,jpg,gif,svg",
            'title' => "required",
        ]);

        extract($request->all());

        if ($request->hasFile('image')) {

            $image_path = storeImage($request,$request->image,'news_blogs');
        } else {
            $image_path = '';
        }

        $request->merge(["image_path"=> $image_path]);

        $addNews = $this->createNewsBlogs($request);
        if($addNews){
            return back()->with(["success" => config('globalMessages.news_blogs_create_success') ]);
        }else{
            return back()->with(["error" => config('globalMessages.news_blogs_create_error')]);
        }

    }

    public function editNewsBlogs(Request $request)
    {
        $request->validate([
            'title' => "required",
        ]);

        extract($request->all());

        $checkNews = $this->updateNewsBlogs($request);
        if($checkNews){
            return back()->with(["success" => config('globalMessages.news_blogs_update_success')]);
        }else{
            return back()->with(["error" => config('globalMessages.news_blogs_update_error') ]);
        }
    }



}
