<?php
namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\ResourceCategory;
use DB;
use App\Http\Traits\ResourceCategoryTraits;

class ResourceCategoryController extends Controller
{
    use ResourceCategoryTraits;

    public function getResourceCategoryList(Request $request)
    {
       $ResourceCategory = $this->getAllResourceCategory();
       $getDynamicFields = getIndexFields(Request(),'resource_category');


       return view('resource-category.index')->with(['ResourceCategory'=>$ResourceCategory,'fields_name'=>$getDynamicFields]);
    }

    public function addResourceCategory(Request $request): \Illuminate\Http\RedirectResponse
    {
        $request->validate([
            'image' => "required|image|mimes:jpeg,png,jpg,gif,svg",
            'name' => "required",
        ]);

        extract($request->all());

        if ($request->hasFile('image')) {

            $image_path = storeImage($request,$request->image,'resource_category');
        } else {
            $image_path = '';
        }

        $request->merge(["image_path"=> $image_path]);

        $addRescat = $this->CreateResCategory($request);
        if($addRescat){
            return back()->with(["success" => config('globalMessages.resource_category_create_success') ]);
        }else{
            return back()->with(["error" => config('globalMessages.resource_category_create_error')]);
        }

    }

    public function editResourceCategory(Request $request): \Illuminate\Http\RedirectResponse
    {
        $request->validate([
            'name' => "required",
        ]);

        extract($request->all());

        $checkResCat = $this->updateResCategory($request);
        if($checkResCat){
            return back()->with(["success" => config('globalMessages.resource_category_update_success')]);
        }else{
            return back()->with(["error" => config('globalMessages.resource_category_update_error') ]);
        }
    }

}
