<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use ICal\ICal;
use App\Models\Event;


class UploadEventController extends Controller
{
   public function getUplodeEvent()
   {
       return view('upload-event.index');
   }

   public function uplodeEvent(Request $request)
   {
      $ical  = new Ical($request->file('ics'));
      
      $events = $ical->events();

      foreach($events as $key=>$event){

         $start_date = date('Y-m-d H:i:s', strtotime($event->dtstart));
         $end_date = date('Y-m-d H:i:s', strtotime($event->dtend));
         $title = addslashes($event->summary);
         $explode_uid = explode('@', $event->uid);
         $uid = $explode_uid[0];
         $description = addslashes($event->description);

         $add_event = new Event();
         $add_event->uid = $uid;
         $add_event->title = $title;
         $add_event->start_date = $start_date;
         $add_event->end_date = $end_date;
         $add_event->description = $description;
         $add_event->save();
      }
      return back()->with(['success'=> 'Event Added successfully']);
   }
}
