<?php

namespace App\Http\Traits;
use App\Models\DirectoryCategory;
use DB;

trait DirectoryCategoryTraits
{
    public function getAllDirectoryCategory()
    {
        return DirectoryCategory::all();
    }

    public function selectAllDirectoryCategory()
    {
        return DirectoryCategory::select('*',DB::raw("CONCAT('".env('APP_URL')."/',image_path) as image_path"))
        ->where('category_status','active')
        ->get();
    }

    public function getDirectoryCategoryDetail($dir_cat_id)
    {
        return DirectoryCategory::find($dir_cat_id);
    }

    public function createDirectoryCategory($request)
    {
        return DirectoryCategory::create($request->all());
    }

    public function updateDirectoryCategory($request)
    {
        $dir_cat_id = $request->get('dir_cat_id');

        $arr = $request->all();
        unset($arr['_token']);
        unset($arr['dir_cat_id']);

        $currentImagePath = $this->getImagePath($dir_cat_id);
        $image_path = "";
        if ($request->hasFile('image')) {
            $image_path = storeImage($request,$request->image,'directory_category');
        } else {
            $image_path = '';
        }

        if($image_path != ""){
            $arr = array_merge($arr,['image_path' => $image_path]);
        }
        unset($arr['image']);

        $dircategory= DirectoryCategory::where('id',$dir_cat_id)->update($arr);
        if($image_path != "" && $currentImagePath != ""){
            if(file_exists($currentImagePath)){
                unlink($currentImagePath);
            }
        }

        return $dircategory;
    }

    public function getImagePath($dir_cat_id)
    {
        $image_path = "";

        $dircategory = DirectoryCategory::find($dir_cat_id);
        if($dircategory){
            $image_path = $dircategory->image_path;
        }

        return $image_path;
    }

    public function dirCategoryDelete($request)
    {
        $dir_cat_id = $request->get('dir_cat_id');
        return DirectoryCategory::where('id',$dir_cat_id)->delete();
    }
}
