<?php

namespace App\Models;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Event extends Model
{
    use softDeletes;
    protected $table = 'events';

    protected $fillable = [
        'id',
        'image_path',
        'category_id',
        'start_date',
        'end_date',
        'title',
        'description',
        'latitude',
        'longitude',
        'url',
        'phone',
        'event_status',
        'order_num',
        'created_at',
        'updated_at'
    ];

    protected $casts = [
        'id' => 'integer',
        'image_path' => 'string',
        'category_id' => 'integer',
        'start_date' => 'datetime:Y-m-d H:i:s',
        'end_date' => 'datetime:Y-m-d H:i:s',
        'title' => 'string',
        'description' => 'string',
        'latitude' => 'string',
        'longitude' => 'string',
        'url' => 'string',
        'phone' => 'string',
        'event_status' => 'string',
        'order_num' => 'integer',
        'created_at' => 'datetime',
        'updated_at' => 'datetime'
    ];
}
