<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('resource', function (Blueprint $table) {
            $table->id();
            $table->string('image_path',199);
            $table->string('title',99);
            $table->integer('category_id');
            $table->text('description');
            $table->text('facebook_url');
            $table->text('instagram_url');
            $table->text('video_url');
            $table->text('url');
            $table->text('address');
            $table->string('latitude',25);
            $table->string('longitude',25);
            $table->string('phone',15);
            $table->enum('resource_status',['active','inactive'])->default('active');
            $table->integer('order_num');
            $table->softDeletes();
            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->useCurrent()->useCurrentOnUpdate();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('resource');
    }
};
