@extends('layouts.app')
@section('title',  $fields_name['header_title'])
@section('content')
<div class="content">
  <div class="row">
    <div class="col-md-12">
      <div class="card">
        <div class="card-header">
          <button type="button" class="btn btn-primary float-right open-add-modal" data-toggle="modal" data-target="#add-ads-modal"> ADD </button>
          <h4 class="card-title"> {{$fields_name['table_header_title']}}</h4>
          @if ($message = Session::get('success'))
          <div class="alert alert-success alert-block">
            <button type="button" class="close" data-dismiss="alert">×</button>
            <strong>{{ $message }}</strong>
          </div>
          @endif

          @if ($message = session()->get('error'))
          <div class="alert alert-danger alert-block">
            <button type="button" class="close" data-dismiss="alert">×</button>
            <strong>{{ $message }}</strong>
          </div>
          @endif
          @if (count($errors) > 0)
          <div class="alert alert-danger">
            <button type="button" class="close" data-dismiss="alert">×</button>
            <strong>Error!</strong> There were some problems with your input.
            <ul>
              @foreach ($errors->all() as $error)
              <li>{{ $error }}</li>
              @endforeach
            </ul>
          </div>
          @endif
        </div>
        <div class="card-body">
          <div class="table-responsive">
            <table class="table" id="ads-table">
              <thead class="text-primary">
                <th>#</th>
                <th>Images</th>
                <th>URL</th>
                <th>Expiration</th>
                <th>Total Clicks</th>
                <th>Order</th>
                <th>Ads Status</th>
                <th class="text-center">Action</th>
              </thead>
              <tbody>
                @foreach($add_ads as $row)
                <tr>
                  <td>{{ $loop->iteration }}</td>
                  <td>
                    @if ($row->image_path != null && file_exists($row->image_path))
                        <img src="{{url($row->image_path)}}" height="75" />
                    @else
                        <span>-</span>
                    @endif
                  </td>
                  <td>
                      @if($row->url != "")
                          <a href="{{ $row->url }}" target="_blank" > {{$row->url}} </a>
                      @else
                          <span> - </span>
                      @endif
                  </td>
                  <td>{{ date('d-m-Y',strtotime($row->expiration)) }}</td>
                  <td>{{ $row->ads_click_count }}</td>
                  <td>{{ $row->order_num }}</td>
                  <td>{{ ucfirst($row->ads_status) }}</td>
                  <td class="text-center">
                    <div class="dropdown">
                      <button type="button" class="btn btn-primary dropdown-toggle" data-toggle="dropdown">
                        Action
                      </button>
                      <div class="dropdown-menu">
                        <a class="dropdown-item edit-ads-modal" data-id="{{ $row->id }}" href="javascript:void(0)">Edit</a>
                        <a class="dropdown-item delete-ads" data-id="{{ $row->id }}" href="javascript:void(0)">Delete</a>
                      </div>
                    </div>
                  </td>
                </tr>
                @endforeach
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>


<!-- add Modal -->
@include('ads.modal.add-ads-modal')
<!-- edit Modal -->
@include('ads.modal.edit-ads-modal')

@endsection

@section('script-section')
    <script>

        $(document).ready(function() {
            $('#ads-table').DataTable();



            $('#expiration').daterangepicker({
                singleDatePicker: true,
                minDate: new Date()
            });

            $('.expiration1').daterangepicker({
                singleDatePicker: true,
                minDate: new Date()
            });

            $('.open-add-modal').on('click',function(){
                $('#AddModal').find('form').trigger('reset');
                let $alerts = $('#AddModal');
                $alerts.validate().resetForm();
                $alerts.find('.error').removeClass('error');
            });

            $('#add-ads-form').validate({
                rules: {
                    image: {
                        required: true,
                    },
                    url: {
                        required: true,
                    },
                    expiration: {
                        required: true,
                    }
                },
                messages: {
                    image: {
                        required: "{{ config('globalMessages.required_message.image') }}"
                    },
                    url: {
                        required: "{{ config('globalMessages.required_message.url') }}"
                    },
                    expiration: {
                        required: "{{ config('globalMessages.required_message.expiration') }}"
                    }
                }
            });

            $('.edit-ads-modal').on('click',function(){
                let ads_id = $(this).data('id');
                $.ajax({
                    type:"GET",
                    url: "{{ url( 'api/'.appName(Request()) .'/get-ads-details' ) }}/" + ads_id,
                    success:function(data){
                        if (data.status == 'success') {

                            $('.url1').val(data.data.url);
                            $('.ads_status1').val(data.data.ads_status);
                            $('.expiration1').val(moment(data.data.expiration).format('MM/DD/Y'));
                            $('.order1').val(data.data.order_num);
                            $('#e_ads_id').val(data.data.id);

                            $('#edit-ads-modal-id').modal('show');
                        } else {
                            Swal.fire({
                                icon: 'error',
                                title: "Error!",
                                text: data.message
                            });
                        }
                    },
                    error:function(err){
                        console.log(err);
                    }
                });

            });

            $('#edit-ads-form').validate({
                rules:{
                    url: {
                        required: true,
                    },
                    expiration: {
                        required: true,
                    }
                },
                messages: {
                    url: {
                        required: "{{ config('globalMessages.required_message.url') }}"
                    },
                    expiration: {
                        required: "{{ config('globalMessages.required_message.expiration') }}"
                    }
                }
            });

            // reset edit form and validation errors and message
            $('#edit-ads-modal-id').on('hidden.bs.modal', function () {
                $(this).find('form').trigger('reset');
                let $alerts = $('#edit-ads-form');
                $alerts.validate().resetForm();
                $alerts.find('.error').removeClass('error');
            });

            // reset add form and validation errors and message
            $('#add-ads-modal').on('hidden.bs.modal', function () {
                $(this).find('form').trigger('reset');
                let $alerts = $('#add-ads-form');
                $alerts.validate().resetForm();
                $alerts.find('.error').removeClass('error');
            });

            $('.delete-ads').on('click',function(){
                let ad_id = $(this).data('id');

                Swal.fire({
                    icon:"warning",
                    title:"Are you sure?",
                    text:"Are you sure want to delete this ad?",
                    showConfirmButton: true,
                    showCancelButton: true,
                    confirmButtonText: "Yes",
                    cancelButtonText: "No"
                }).then((ok) => {
                        if(ok['isConfirmed']){
                            $.ajax({
                                type:"POST",
                                url: "{{ url('api/'.appName(Request()) . '/delete-ads') }}",
                                data:{
                                    "_token": "{{ csrf_token() }}",
                                    "ads_id": ad_id
                                },
                                success:function(data){
                                    if(data.status == 'success'){
                                        Swal.fire({
                                            icon:"success",
                                            title:"Success!",
                                            text: data.message
                                        }).then((ok) => {
                                            if(ok){
                                                window.location.reload();
                                            }
                                        });
                                    }else{
                                        Swal.fire({
                                           icon:"error",
                                            title:"Error!",
                                            text: data.message
                                        });
                                    }
                                },
                                error:function(err){
                                    console.log(err)
                                }
                            });
                        }
                });
            });
        });



    </script>
@endsection
