@extends('layouts.app')
@section('title',$fields_name['header_title'])
@section('content')

<div class="content">
    <div class="row">
      <div class="col-md-12">
          @if ($message = session()->get('success'))
              <div class="alert alert-success alert-block">
                  <button type="button" class="close" data-dismiss="alert">×</button>
                  <strong>{{ $message }}</strong>
              </div>
          @endif

          @if ($message = session()->get('error'))
              <div class="alert alert-danger alert-block">
                  <button type="button" class="close" data-dismiss="alert">×</button>
                  <strong>{{ $message }}</strong>
              </div>
          @endif
        <div class="card">
          <div class="card-header">
            <a href="{{ url(baseRedirectUrl(Request()) . '/view-notification')  }}">
                <button type="button" class="btn btn-primary float-right">Send Notification</button>
            </a>
            <h4 class="card-title"> {{$fields_name['table_header_title']}} </h4>
          </div>
          <div class="card-body">
            <div class="table-responsive">
              <table class="table" id="notification-list-table">
                <thead class="text-primary">
                  <th>#</th>
                  <th>Title</th>
                  <th>Total Notification</th>
                  <th>Success</th>
                  <th>Failed </th>
                </thead>
                <tbody>

                </tbody>
              </table>
            </div>
          </div>
        </div>
      </div>
    </div>
</div>

@endsection

@section('script-section')
    <script>
        $(document).ready(function() {
            $('#notification-list-table').DataTable();
        });
    </script>
@endsection
