@extends('layouts.app')
@section('title', 'Send Notification')
@section('content')
<div class="content">
    <div class="row">
      <div class="col-md-12">
        <div class="card">
          <div class="card-header">
            <h4 class="card-title"> Send Notification</h4>
            @if ($message = session()->get('success'))
            <div class="alert alert-success alert-block">
              <button type="button" class="close" data-dismiss="alert">×</button>
              <strong>{{ $message }}</strong>
            </div>
            @endif

            @if ($message = session()->get('error'))
            <div class="alert alert-danger alert-block">
              <button type="button" class="close" data-dismiss="alert">×</button>
              <strong>{{ $message }}</strong>
            </div>
            @endif
            @if (count($errors) > 0)
            <div class="alert alert-danger">
              <button type="button" class="close" data-dismiss="alert">×</button>
              <strong>Error!</strong> There were some problems with your input.
              <ul>
                @foreach ($errors->all() as $error)
                <li>{{ $error }}</li>
                @endforeach
              </ul>
            </div>
            @endif
          </div>
          <div class="card-body">
            <div class="content">
                <form id="addform" method="post" action="{{ url(baseRedirectUrl(Request()). '/send-notification' ) }}" >
                  @csrf
                    {{-- <div class="form-group">
                        <label for="addInput2">{{config('globalLabel.form_label.title')}}</label>
                        <input type="text" class="form-control" name="title" id="title" placeholder="Enter Title">
                    </div>
                    <div class="form-group">
                        <label for="description">{{config('globalLabel.form_label.description')}}</label>
                        <textarea name="description" id="description" class="form-control"></textarea>
                    </div> --}}
                    @if(count(getFormFields(Request(),'notification')) > 0)
                    @foreach(getFormFields(Request(),'notification') as $field_item)
                        @if(!in_array($field_item['input_type'],["textarea","select_user"]))
                            <div>
                                <div class="form-group">
                                    <div class="form-group">
                                        <label for="{{$field_item['id']}}">{{ $field_item['label'] }}</label>
                                        <input type="{{$field_item['input_type']}}" accept="image/*" class="{{$field_item['class']}}" name="{{$field_item['name']}}" id="{{$field_item['id']}}" style="opacity: unset; position: unset" placeholder="{{$field_item['placeholder']}}" value="{{ $field_item['value'] }}">
                                    </div>
                                </div>
                            </div>
                        @endif

                        @if ($field_item['input_type'] == "textarea")
                            <div class="form-group">
                                <label for="{{$field_item['id']}}">{{ $field_item['label'] }}</label>
                                <textarea name="{{$field_item['name']}}" id="{{$field_item['id']}}" class="{{$field_item['class']}}"></textarea>
                            </div>
                        @endif

                        @if ($field_item['input_type'] == 'select_user' )
                                <div class="form-group">
                                    <label for="{{$field_item['id']}}">{{ $field_item['label'] }}</label>
                                    <select name="{{$field_item['name']}}" id="{{$field_item['id']}}" class="{{$field_item['class']}}">
                                    @foreach ($field_item['option'] as $item)
                                        <option value="{{$item['value']}}">{{$item['text']}}</option>  
                                    @endforeach
                                    </select>
                                </div>
                        @endif

                    @endforeach
                    @endif

                    <div class="form-group">
                        <button type="submit" id="submit" class="btn btn-primary ">{{ config('globalLabel.send_notification_send_btn') }}</button>
                        <a href="javascript:window.history.back()">
                            <button type="button" class="btn btn-secondary close-btn">{{ config('globalLabel.send_notification_close_btn') }}</button>
                        </a>
                    </div>
                </form>
              </div>
          </div>
        </div>
      </div>
    </div>
</div>
@endsection

@section('script-section')
    <script>
        $('#addform').validate({
            rules: {

                title: {
                    required: true,
                },
                description: {
                    required: true,
                },
            },
            messages: {
                title: {
                    required: "{{ config('globalMessages.required_message.title') }}"
                },
                description: {
                    required: "{{ config('globalMessages.required_message.description') }}",
                },
            },
        });

    </script>
@endsection
