<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AdsController;
use App\Http\Controllers\AccountController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\Auth\ForgotPasswordController;
use App\Http\Controllers\EventController;
use App\Http\Controllers\EventCategoryController;
use App\Http\Controllers\DirectoryCategoryController;
use App\Http\Controllers\DirectoryController;
use App\Http\Controllers\Auth\LoginController;
use App\Http\Controllers\MapCategoryController;
use App\Http\Controllers\MapDirectoryController;
use App\Http\Controllers\NotificationController;
use App\Http\Controllers\ResourceController;
use App\Http\Controllers\ResourceCategoryController;
use App\Http\Controllers\NewsBlogsController;
use App\Http\Controllers\AppCongifController;
use App\Http\Controllers\UploadEventController;
use App\Http\Controllers\PrivacyController;
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/404',function(){
    return view('errors.404');
});

Route::group(['prefix' => 'app/{app_name}','middleware' => 'DatabaseConnectionChooser'], function(){

    // Route::get('/privacy',function(){
    //     return view('privacy-policy.privacy');
    // });
        Route::get('/privacy',[PrivacyController::class,'privacyList']);

    Route::get('/login', function () {
        return view('auth.login');
    })->name('login');
    Route::post('post-login', [LoginController::class, 'indexLogin'])->name('post-login');

    Route::get('logout', [LoginController::class, 'logout']);
    Route::get('/forgot-password',function(){
        return view('auth.forgot-password');
    });
    Route::post('/forgot-password-request',[ForgotPasswordController::class,"forgotPasswordRequest"]);


    Route::group(['middleware' => 'auth.custom'],function(){

        Route::get('/', [DashboardController::class,'index'])->name('Dashboard');

        //Accounts
        Route::controller(AccountController::class)->group(function(){
            Route::get('/accounts',"getAccountList");
            Route::post('/add-account',"addAccount")->name('add-account');
            Route::post('/edit-account',"editAccount")->name('edit-account');
        });

         // Event Category
         Route::controller(EventCategoryController::class)->group(function(){
            Route::get('/events-category','getEventCategoryList');
            Route::post('/add-event-category','addEventCategory')->name('add-event-category');
            Route::post('/edit-event-category','editEventCategory')->name('edit-event-category');
        });

        // Event
        Route::controller(EventController::class)->group(function(){
            Route::get('/events','getEventList');
            Route::post('/add-event','addEvent')->name('add-event');
            Route::post('/edit-event','editEvent')->name('edit-event');
        });

        // Ads
        Route::controller(AdsController::class)->group(function(){
            Route::get('/ads','adsList');
            Route::post('/add-ads','addAds')->name('add-ads');
            Route::post('/edit-ads','editAds')->name('edit-ads');
        });

        // Directory category
        Route::controller(DirectoryCategoryController::class)->group(function(){
            Route::get('/directory-category', 'getDirectoryCategoryList');
            Route::post('/add_directory_category','addDirectoryCategory')->name('add_directory_category');
            Route::post('/edit_directory_category','editDirectoryCategory')->name('edit_directory_category');
        });

        // Directory
        Route::controller(DirectoryController::class)->group(function(){
            Route::get('/directory','getDirectoryList');
            Route::post('/add_directory','addDirectory')->name('add_directory');
            Route::post('/edit_directory','editDirectory')->name('edit_directory');
        });

        // category
        Route::controller(MapCategoryController::class)->group(function(){
            Route::get('/category', 'getMapCategoryList');
            Route::post('/add_category','addMapCategory')->name('add_category');
            Route::post('/edit_category','editMapCategory')->name('edit_category');
        });


        // Map Directory

        Route::controller(MapDirectoryController::class)->group(function(){
            Route::get('/map-directory', 'getMapDirectoryList');
            Route::post('/add_map_directory','addMapDirectory')->name('add_map_directory');
            Route::post('/edit_map_directory','editMapDirectory')->name('edit_map_directory');
        });

        // Resource category
        Route::controller(ResourceCategoryController::class)->group(function(){
            Route::get('/rescategory', 'getResourceCategoryList');
            Route::post('/add_resource_category','addResourceCategory')->name('add_resource_category');
            Route::post('/edit_resource_category','editResourceCategory')->name('edit_resource_category');
        });

        // Resource
        Route::controller(ResourceController::class)->group(function(){
            Route::get('/resource', 'getResourceList');
            Route::post('/add_resource','addResource')->name('add_resource');
            Route::post('/edit_resource','editResource')->name('edit_resource');
        });

        // News Blogs
        Route::controller(NewsBlogsController::class)->group(function(){
            Route::get('/news-blogs','getNewsBlogsList');
            Route::post('/add_news_blogs','addNewsBlogs')->name('add_news_blogs');
            Route::post('/edit_news_blogs','editNewsBlogs')->name('edit_news_blogs');
        });

        // Notification

        Route::controller(NotificationController::class)->group(function(){
            Route::get('/notification-list', 'getNotificationList');
            Route::get('/view-notification', 'viewNotification');
            Route::post('/send-notification','sendNotification');
        });


        // App Config
        Route::controller(AppCongifController::class)->group(function(){
            Route::get('/app-config', 'appconfig');
            Route::post('/update-app-config','editAppConfig');
        });

        // Upload Event
        Route::controller(UploadEventController::class)->group(function(){
            Route::get('/upload-event', 'getUplodeEvent');
            Route::post('upload_events','uplodeEvent');
        });

    });

});

