<?php if('corvallis' == appName(Request())): ?>
    <?php $__env->startSection('title', 'Parks Entertainment Category'); ?>
<?php endif; ?>
<?php if('lebanon' == appName(Request())): ?>
    <?php $__env->startSection('title', 'Parks Trails Category'); ?>
<?php endif; ?>
<?php $__env->startSection('content'); ?>
<div class="content">
  <div class="row">
    <div class="col-md-12">
      <div class="card">
        <div class="card-header">
          <button type="button" class="btn btn-primary float-right" onclick="clearUser();" data-toggle="modal" data-target="#AddModal"> ADD </button>
          
          <?php if('corvallis' == appName(Request())): ?>
          <h4 class="card-title">Parks Entertainment Category List</h4>
          <?php endif; ?>
          <?php if('lebanon' == appName(Request())): ?>
          <h4 class="card-title">Parks Trails Category List</h4>
          <?php endif; ?>
          <?php if($message = Session::get('success')): ?>
          <div class="alert alert-success alert-block">
            <button type="button" class="close" data-dismiss="alert">×</button>
            <strong><?php echo e($message); ?></strong>
          </div>
          <?php endif; ?>

          <?php if(count($errors) > 0): ?>
          <div class="alert alert-danger">
            <strong>Whoops!</strong> There were some problems with your input.
            <ul>
              <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <li><?php echo e($error); ?></li>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
          </div>
          <?php endif; ?>
        </div>
        <div class="card-body">
          <div class="table-responsive">
            <table class="table" id="example">
              <thead class=" text-primary">
                <th>#</th>
                <th>Images</th>
                <th>Name</th>
                <th>Order</th>
                <th>Category Status</th>
                <th class="text-center">Action</th>
              </thead>
              <tbody>
                <?php
                ?>
                <?php $__currentLoopData = $dir_cat; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                  <td><?php echo e($loop->iteration); ?></td>
                  <td><?php echo e($row->image_path); ?></td>
                  <td><?php echo e($row->name); ?></td>
                  <td><?php echo e($row->order_num); ?></td>
                  <td><?php echo e($row->category_status); ?></td>
                  <td class="text-center">
                    <div class="dropdown">
                      <button type="button" class="btn btn-primary dropdown-toggle" data-toggle="dropdown">
                        Action
                      </button>
                      <div class="dropdown-menu">
                        <a class="dropdown-item edit" data-id="<?php echo e($row->id); ?>" data-name="directory_category">Edit</a>
                        <a class="dropdown-item delete" data-id="<?php echo e($row->id); ?>" data-name="directory_category">Delete</a>
                      </div>
                    </div>
                  </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>


<!-- Add Modal -->
<div class="modal fade" id="AddModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
      <div class="modal-content">
        <form id="addform" method="post" action="<?php echo e(url('/app/' .appName(Request()). '/insert_parks_category')); ?>" enctype="multipart/form-data">
          <?php echo e(csrf_field()); ?>

          <div class="modal-header">
            <h5 class="modal-title" id="exampleModalLabel">Add Category</h5>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true close-btn">×</span>
            </button>
          </div>
          <div class="modal-body">
            <div class="form-group">
              <label for="addInput1">Select Image * <span style="color:red;" class="err_msg"></span></label>
              <input type="file" accept="image/*" class="form-control-file" name="image" id="addInput1" style="opacity: unset; position: unset">
            </div>
            <div class="form-group">
              <label for="addInput7">Name*</label>
              <input type="text" class="form-control" name="name" id="addInput7" >
            </div>
            <div class="form-group">
            <label for="addInput2">Category Status</label>
            <select name="cat_status"  class="form-control">
              <option value="active">Active</option>
              <option value="inactive">Inactive</option>
            </select>
            </div>
            <div class="form-group">
              <label for="addInput12">Order Number</label>
              <input type="text" class="form-control" name="order_num" id="addInput12" maxlength="4" >
            </div>
          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-secondary close-btn" data-dismiss="modal">Close</button>
            <button type="submit" id="submit" class="btn btn-primary">Submit</button>
          </div>
        </form>
      </div>
    </div>
</div>

<!-- edit Modal -->
<div class="modal fade" id="editModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
      <div class="modal-content">
        <form id="editform" method="post" action="<?php echo e(url('/app/' .appName(Request()). '/update_parks_category')); ?>" enctype="multipart/form-data">
          <?php echo e(csrf_field()); ?>

          <div class="modal-header">
            <h5 class="modal-title" id="exampleModalLabel">Edit Category</h5>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true close-btn">×</span>
            </button>
          </div>
          <div class="modal-body">
            <div class="form-group">
              <label for="addInput1">Select Image <span style="color:red;" class="err_msg"></span></label>
              <input type="file" accept="image/*" class="form-control-file" name="image" id="addInput1" style="opacity: unset; position: unset">
            </div>
            <div class="form-group">
              <label for="addInput7">Name *</label>
              <input type="text" class="form-control" name="name" id="name" >
            </div>
            <div class="form-group">
            <label for="addInput2">Category Status</label>
            <select name="cat_status" id="cat_status"  class="form-control">
              <option value="active">Active</option>
              <option value="inactive">Inactive</option>
            </select>
            </div>
            <div class="form-group">
              <label for="addInput12">Order Number</label>
              <input type="text" class="form-control" name="order_num" id="order_num" maxlength="4" >
            </div>
          </div>
          <input type="hidden" name="cat_id" id="cat_id">
          <div class="modal-footer">
            <button type="button" class="btn btn-secondary close-btn" data-dismiss="modal">Close</button>
            <button type="submit" class="btn btn-primary">Save changes</button>
          </div>
        </form>
      </div>
    </div>
</div>

<script>
    $(document).ready(function() {
      // Fill Edit data
      $(document).on('click', '.edit', function() {
        $("#editform").find('.has-error').removeClass("has-error");
        $("#editform").find('.has-success').removeClass("has-success");
        $("#editform").find('.err_msg').text("");
        $('#editform').find('.form-control-feedback').remove();
        var id = $(this).data('id');
        var name = $(this).data('name');
        $.ajax({
          type: 'POST',
          url: "<?php echo e(url('/app/' .appName(Request()). '/getpc')); ?>",
          headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
          },
          data: {
            'id': id,
            'name': name
          },
          success: function(data) {
            if (data) {
              $('#cat_id').val(data.id);
              $('#name').val(data.name);
              $('#order_num').val(data.order_num);
              $('#cat_status').val(data.category_status);
              $('#editModal').modal('show');
            }
          }
        });
      });
      $('#addform').validate({
        rules: {
          image: {
            required: true,
          },
          name: {
            required: true,
          }

        },
        messages: {
          image: {
            required: "This field is required",
          },
          name: {
            required: "This field is required"
          }

        },
        errorPlacement: function(error, element) {
          element.closest("div").addClass('has-error');
        },
        success: function(error, element) {
          $(element).closest("div").removeClass('has-error');
        }
      });
      $('#editform').validate({
        rules: {
          name: {
            required: true,
          }
        },
        messages: {
           name: {
            required: "This field is required"
          }

        },
        errorPlacement: function(error, element) {
          element.closest("div").addClass('has-error');
        },
        success: function(error, element) {
          $(element).closest("div").removeClass('has-error');
        }
      });
    });

    // delete
    $(document).on('click', '.delete', function() {
        if (confirm("Are you sure You want to delete it?")) {
          var id = $(this).data('id');
          var name = $(this).data('name');
          $.ajax({
            type: 'POST',
            url: "<?php echo e(url('/app/' .appName(Request()). '/parkdelete')); ?>",
            headers: {
              'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            data: {
              'id': id,
              'name': name
            },
            success: function(data) {
              if (data) {
                alert("Delete successfully.");
                window.location.reload();
              } else {
                alert("Somthing went wrong.");
              }
            }
          });
        }
    });
</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\chamber-ddd\resources\views/parks_category/index.blade.php ENDPATH**/ ?>