<?php $__env->startSection('content'); ?>

<div class="content">
    <div class="row">
      <div class="col-md-12">
        <div class="card">
          <div class="card-header">
            <button type="button" class="btn btn-primary float-right" onclick="clearUser();" data-toggle="modal" data-target="#AddModal"> ADD </button>
            <h4 class="card-title"> Accounts List</h4>
            <?php if($message = Session::get('success')): ?>
            <div class="alert alert-success alert-block">
              <button type="button" class="close" data-dismiss="alert">×</button>
              <strong><?php echo e($message); ?></strong>
            </div>
            <?php endif; ?>
            <?php if($message = Session::get('error')): ?>
            <div class="alert alert-danger alert-block">
              <button type="button" class="close" data-dismiss="alert">×</button>
              <strong><?php echo e($message); ?></strong>
            </div>
            <?php endif; ?>
            <?php if(count($errors) > 0): ?>
            <div class="alert alert-danger">
              <strong>Whoops!</strong> There were some problems with your input.
              <ul>
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li><?php echo e($error); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </ul>
            </div>
            <?php endif; ?>
          </div>
          <div class="card-body">
            <div class="table-responsive">
              <table class="table" id="example">
                <thead class=" text-primary">
                  <th>#</th>
                  <th>Email</th>
                  <th>Name</th>
                  <th>Date</th>
                  <th class="text-center">Action</th>
                </thead>
                <tbody>
                  <?php $__currentLoopData = $account; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <tr>
                    <td><?php echo e($loop->iteration); ?></td>
                    <td><?php echo e($user->email); ?></td>
                    <td><?php echo e($user->firstname.' '.$user->lastname); ?></td>
                    <td><?php echo e(\Carbon\Carbon::parse($user->created_at)->format('d/m/Y')); ?></td>
                    <td class="text-center">
                      <div class="dropdown">
                        <button type="button" class="btn btn-primary dropdown-toggle" data-toggle="dropdown">
                          Action
                        </button>
                        <div class="dropdown-menu">
                          <a class="dropdown-item edit" data-id="<?php echo e($user->id); ?>" data-name="users" href="#">Edit</a>
                          <a class="dropdown-item delete" data-id="<?php echo e($user->id); ?>" data-name="users" href="#">Delete</a>
                        </div>
                      </div>
                    </td>
                  </tr>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
              </table>
            </div>
          </div>
        </div>
      </div>
    </div>
</div>


<!-- add Modal -->
<div class="modal fade" id="AddModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="exampleModalLabel">Add Accounts</h5>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true close-btn">×</span>
          </button>
        </div>
        <div class="modal-body">
          <form id="addform" method="post"  action="<?php echo e(url('/app/' .appName(Request()). '/add_accounts' )); ?>" >
            <?php echo csrf_field(); ?>
            <div class="form-group">
              <label for="exampleFormControlInput1">Email *</label>
              <input type="email" class="form-control" name="email" id="exampleFormControlInput1" placeholder="Enter Email">
            </div>
            <div class="form-group">
              <label for="exampleFormControlInput2">Password *</label>
              <input type="password" class="form-control" name="password" id="exampleFormControlInput2" placeholder="Enter Password">
            </div>
            <div class="form-group">
              <label for="exampleFormControlInput3">First Name *</label>
              <input type="text" class="form-control" name="fname" id="exampleFormControlInput3" placeholder="Enter First Name">
            </div>
            <div class="form-group">
              <label for="exampleFormControlInput4">Last Name *</label>
              <input type="text" class="form-control" name="lname" id="exampleFormControlInput4" placeholder="Enter Last Name">
            </div>
            <div class="form-group">
              <label for="exampleFormControlInput4">Zip Code</label>
              <input type="zipcode" class="form-control" name="zip_code" id="exampleFormControlInput4" placeholder="Enter Zip Code" maxlength="9">
            </div>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary close-btn" data-dismiss="modal">Close</button>
          <button type="submit" id="submit" class="btn btn-primary close-modal adddata">Submit</button>
        </div>
      </div>
      </form>
    </div>
</div>

<!-- Edit Model -->
<div class="modal fade" id="updateModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="exampleModalLabel">Edit Account</h5>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">×</span>
          </button>
        </div>
        <div class="modal-body">
          <form id="editform" method="post" action="<?php echo e(url('/app/' .appName(Request()). '/editaccount' )); ?>">
            <?php echo csrf_field(); ?>
            <div class="form-group">
              <label for="editInput1">Email *</label>
              <input type="email" class="form-control" name="email" id="email" placeholder="Enter Name">
            </div>

            <div class="form-group">
              <label for="editInput3">First Name *</label>
              <input type="text" class="form-control" name="fname" id="fname" placeholder="Enter First Name">
            </div>
            <div class="form-group">
              <label for="editInput4">Last Name *</label>
              <input type="text" class="form-control" name="lname" id="lname" placeholder="Enter Last Name">
            </div>

            <div class="form-group">
              <label for="exampleFormControlInput4">Zip Code</label>
              <input type="zipcode" class="form-control" name="zip_code" id="zip_code" placeholder="Enter Zip Code" maxlength="9">
            </div>

            <input type="hidden" name="id" id="id">
            <input type="hidden" name="name" id="name">

        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-dismiss="modal" data-dismiss="modal">Close</button>
          <button type="submit" class="btn btn-primary editdata">Save changes</button>
        </div>
        </form>
      </div>
    </div>
</div>

<script>
    $(document).ready(function() {
      // Fill Edit data
      $(document).on('click', '.edit', function() {
        $("#editform").find('.has-error').removeClass("has-error");
        $("#editform").find('.has-success').removeClass("has-success");
        $("#editform").find('.err_msg').text("");
        $('#editform').find('.form-control-feedback').remove();
        var id = $(this).data('id');
        var name = $(this).data('name');
        $.ajax({
          type: 'POST',
          url: "<?php echo e(url('/app/' .appName(Request()). '/getuser')); ?>",
          headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
          },
          data: {
            'id': id,
            'name': name
          },
          success: function(data) {
            if (data) {
              $('#id').val(id);
              $('#name').val(name);
              $('#email').val(data.email);
              $('#fname').val(data.firstname);
              $('#lname').val(data.lastname);
              $('#zip_code').val(data.zip_code);
              $('#updateModal').modal('show');
            }
          }
        });
      });
      jQuery.validator.addMethod("validate_email", function(value, element) {
        if (/^([a-zA-Z0-9_\.\-])+\@(([a-zA-Z0-9\-])+\.)+([a-zA-Z0-9]{2,4})+$/.test(value)) {
          return true;
        } else {
          return false;
        }
      }, "Please enter a valid Email.");
      $('#addform').validate({
        rules: {
          email: {
            required: true,
            validate_email: true
          },
          password: {
            required: true,
          },
          fname: {
            required: true,
          },
          lname: {
            required: true,
          }
        },
        messages: {
          email: {
            required: "This field is required",
            email: "Email format is invalid"
          },
          password: {
            required: "This field is required"
          },
          fname: {
            required: "This field is required"
          },
          lname: {
            required: "This field is required"
          }

        },
        errorPlacement: function(error, element) {
          element.closest("div").addClass('has-error');
        },
        success: function(error, element) {
          $(element).closest("div").removeClass('has-error');
        }
      });
      $('#editform').validate({
        rules: {
          email: {
            required: true,
            validate_email: true

          },
          fname: {
            required: true,
          },
          lname: {
            required: true,
          },


        },
        messages: {
          email: {
            required: "Email field is required",
            email: "Email format is invalid"
          },
          fname: {
            required: "This field is required",
          },
          lname: {
            required: "This field is required",

          }

        },
        errorPlacement: function(error, element) {
          element.closest("div").addClass('has-error');
        },
        success: function(error, element) {
          $(element).closest("div").removeClass('has-error');
        }
      });

    });

    // delete
    $(document).on('click', '.delete', function() {
        if (confirm("Are you sure You want to delete it?")) {
          var id = $(this).data('id');
          var name = $(this).data('name');
          $.ajax({
            type: 'POST',
            url: "<?php echo e(url('/app/' .appName(Request()). '/deletedata')); ?>",
            headers: {
              'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            data: {
              'id': id,
              'name': name
            },
            success: function(data) {
              if (data) {
                alert("Delete successfully.");
                window.location.reload();
              } else {
                alert("Somthing went wrong.");
              }
            }
          });
        }
    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\chamber-ddd\resources\views/accounts/index.blade.php ENDPATH**/ ?>