
<?php $__env->startSection('title', $fields_name['header_title']); ?>

<?php $__env->startSection('content'); ?>

<div class="content">
    <div class="row">
      <div class="col-md-12">
        <div class="card">
          <div class="card-header">
            <button type="button" class="btn btn-primary float-right open-add-modal"  data-toggle="modal" data-target="#AddModal"> ADD </button>
            <h4 class="card-title"> <?php echo e($fields_name['table_header_title']); ?> </h4>
            <?php if($message = session()->get('success')): ?>
            <div class="alert alert-success alert-block">
              <button type="button" class="close" data-dismiss="alert">×</button>
              <strong><?php echo e($message); ?></strong>
            </div>
            <?php endif; ?>
            <?php if($message = session()->get('error')): ?>
            <div class="alert alert-danger alert-block">
              <button type="button" class="close" data-dismiss="alert">×</button>
              <strong><?php echo e($message); ?></strong>
            </div>
            <?php endif; ?>
            <?php if(count($errors) > 0): ?>
            <div class="alert alert-danger">
              <button type="button" class="close" data-dismiss="alert">×</button>
              <strong>Error!</strong> There were some problems with your input.
              <ul>
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li><?php echo e($error); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </ul>
            </div>
            <?php endif; ?>
          </div>
          <div class="card-body">
            <div class="table-responsive">
              <table class="table" id="account-table">
                <thead class=" text-primary">
                  <th>#</th>
                  <th>Email</th>
                  <th>Name</th>
                  <th>Date</th>
                  <th class="text-center">Action</th>
                </thead>
                <tbody>
                  <?php $__currentLoopData = $accounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <tr>
                    <td><?php echo e($loop->iteration); ?></td>
                    <td><?php echo e($user->email); ?></td>
                    <td><?php echo e($user->firstname.' '.$user->lastname); ?></td>
                    <td><?php echo e(\Carbon\Carbon::parse($user->created_at)->format('d/m/Y')); ?></td>
                    <td class="text-center">
                      <div class="dropdown">
                        <button type="button" class="btn btn-primary dropdown-toggle" data-toggle="dropdown">
                          Action
                        </button>
                        <div class="dropdown-menu">
                            <?php if($user->admin == 1): ?>
                              <a class="dropdown-item open-edit-modal" data-id="<?php echo e($user->id); ?>" href="javascript:void(0)">Edit</a>
                            <?php else: ?>
                                <a class="dropdown-item open-edit-modal" data-id="<?php echo e($user->id); ?>" href="javascript:void(0)">Edit</a>
                              <a class="dropdown-item open-edit-delete" data-id="<?php echo e($user->id); ?>" href="javascript:void(0)">Delete</a>
                            <?php endif; ?>
                        </div>
                      </div>
                    </td>
                  </tr>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
              </table>
            </div>
          </div>
        </div>
      </div>
    </div>
</div>

<!-- add modal -->
<?php echo $__env->make('accounts.modal.add-account-modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<!-- edit modal -->
<?php echo $__env->make('accounts.modal.edit-account-modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('script-section'); ?>
    <script>
        $(document).ready(function() {
            $('#account-table').DataTable();

            $('.open-add-modal').on('click',function(){
                $('#AddModal').find('form').trigger('reset');
            let $alerts = $('#AddModal');
            $alerts.validate().resetForm();
            $alerts.find('.error').removeClass('error');
            }) ;

        });

        $('#addAccountForm').validate({
            rules:{
                email:{
                    required: true
                },
                password:{
                    required: true
                },
                firstname:{
                    required: true
                },
                lastname:{
                    required: true
                }
            },
            messages:{
                email:{
                    required: "<?php echo e(config('globalMessages.required_message.email')); ?>"
                },
                password:{
                    required: "<?php echo e(config('globalMessages.required_message.password')); ?>"
                },
                firstname:{
                    required: "<?php echo e(config('globalMessages.required_message.first_name')); ?>"
                },
                lastname:{
                    required: "<?php echo e(config('globalMessages.required_message.last_name')); ?>"
                }
            }
        });

        $('.open-edit-modal').on('click',function(){

            $('#e_email').val("");
            $('#e_first_name').val("");
            $('#e_last_name').val("");
            $('#e_zip_code').val("");
            $('#e_account_id').val("");

            let user_id = $(this).data('id');
            $.ajax({
                method: "GET",
                url: "<?php echo e(url( 'api/'.appName(Request()) . '/get-account-details')); ?>/" + user_id,
                success:function(data){

                    if (data.status != 'success') {
                        Swal.fire({
                            icon:'error',
                            title:"Error!",
                            text: data.message
                        })
                        return;
                    }
                    let print_data = data.data;
                    $('.email1').val(print_data.email);
                    $('.first_name1').val(print_data.firstname);
                    $('.last_name1').val(print_data.lastname);
                    $('.zip_code1').val(print_data.zip_code);
                    $('.user_type1').val(print_data.user_type);
                    $('#e_account_id').val(print_data.id);
                    $('#updateModal').modal('show');

                },
                error:function(err){
                    console.log(err)
                }
            });

        });

        $('#edit-account-form').validate({
            rules:{
                email:{
                    required: true
                },
                password:{
                    required: true
                },
                firstname:{
                    required: true
                },
                lastname:{
                    required: true
                }
            },
            messages:{
                email:{
                    required: "<?php echo e(config('globalMessages.required_message.email')); ?>"
                },
                password:{
                    required: "<?php echo e(config('globalMessages.required_message.password')); ?>"
                },
                firstname:{
                    required: "<?php echo e(config('globalMessages.required_message.first_name')); ?>"
                },
                lastname:{
                    required: "<?php echo e(config('globalMessages.required_message.last_name')); ?>"
                }
            }
        });

        // reset edit form and validation errors and message
        $('#updateModal').on('hidden.bs.modal', function () {
            $(this).find('form').trigger('reset');
            let $alerts = $('#updateModal');
            $alerts.validate().resetForm();
            $alerts.find('.error').removeClass('error');
        });

        // reset add form and validation errors and message
        $('#AddModal').on('hidden.bs.modal', function () {
            $(this).find('form').trigger('reset');
            let $alerts = $('#AddModal');
            $alerts.validate().resetForm();
            $alerts.find('.error').removeClass('error');
        });

        $('.open-edit-delete').on('click',function(){
           Swal.fire({
               icon:"warning",
               title: "<?php echo e(config('globalMessages.delete_account_warning_title')); ?>",
               text: "<?php echo e(config('globalMessages.delete_account_warning_text')); ?>",
               showConfirmButton: true,
               showCancelButton: true,
               confirmButtonText: "Yes",
               cancelButtonText: "No"
           }).then((ok) => {
                if(ok['isConfirmed']){
                    let account_id = $(this).data('id');

                    $.ajax({
                        type:"post",
                        url: "<?php echo e(url( 'api/'.appName(Request()) . '/delete-account')); ?>",
                        data:{
                            "_token": "<?php echo e(csrf_token()); ?>",
                            "account_id": account_id
                        },
                        success:function(data){
                            if(data.status == "success"){
                                Swal.fire({
                                   icon:"success",
                                   title:"Success",
                                   text: data.message
                                }).then((ok) => {
                                    if(ok){
                                        window.location.reload();
                                    }
                                });

                            }else{
                                Swal.fire({
                                    icon:"error",
                                    title:"Error",
                                    text: data.message
                                });
                            }
                        },
                        error:function(error){
                            console.log(error);
                        }
                    })
                }
           });
        });
    </script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/agrreemy/public_html/coc/resources/views/accounts/index.blade.php ENDPATH**/ ?>