<?php if('corvallis' == appName(Request())): ?>
    <?php $__env->startSection('title', 'Parks Entertainment '); ?>
<?php endif; ?>
<?php if('lebanon' == appName(Request())): ?>
    <?php $__env->startSection('title', 'Parks Trails '); ?>
<?php endif; ?>
<?php $__env->startSection('content'); ?>
<div class="content">
  <div class="row">
    <div class="col-md-12">
      <div class="card">
        <div class="card-header">
          <button type="button" class="btn btn-primary float-right" onclick="clearUser();" data-toggle="modal" data-target="#AddModal"> ADD </button>
          
          <?php if('corvallis' == appName(Request())): ?>
          <h4 class="card-title">Parks Entertainment List</h4>
          <?php endif; ?>
          <?php if('lebanon' == appName(Request())): ?>
          <h4 class="card-title">Parks Trails List</h4>
          <?php endif; ?>
          <?php if($message = Session::get('success')): ?>
          <div class="alert alert-success alert-block">
            <button type="button" class="close" data-dismiss="alert">×</button>
            <strong><?php echo e($message); ?></strong>
          </div>
          <?php endif; ?>

          <?php if(count($errors) > 0): ?>
          <div class="alert alert-danger">
            <strong>Whoops!</strong> There were some problems with your input.
            <ul>
              <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <li><?php echo e($error); ?></li>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
          </div>
          <?php endif; ?>
        </div>
        <div class="card-body">
          <div class="table-responsive">
            <table class="table" id="example">
              <thead class=" text-primary">
                <th>#</th>
                <th>Image</th>

                <th>Title</th>
                <th>Category</th>
                <th>Address</th>
                <th>Status</th>
                <th>Order</th>
                <th class="text-center">Action</th>
              </thead>
              <tbody>
                <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                  <td><?php echo e($loop->iteration); ?></td>
                  <td><?php echo e($row->image_path); ?></td>
                  <td><?php echo e($row->title); ?></td>
                  <td><?php echo e($row->category_name); ?></td>
                  <td><?php echo e($row->address); ?></td>
                  <td><?php echo e($row->directory_status); ?></td>
                  <td><?php echo e($row->order_num); ?></td>
                  <td class="text-center">
                    <div class="dropdown">
                      <button type="button" class="btn btn-primary dropdown-toggle" data-toggle="dropdown">
                        Action
                      </button>
                      <div class="dropdown-menu">
                        <a class="dropdown-item edit" data-id="<?php echo e($row->id); ?>" data-name="directory" href="#">Edit</a>
                        <a class="dropdown-item delete" data-id="<?php echo e($row->id); ?>" data-name="directory" href="#">Delete</a>
                      </div>
                    </div>
                  </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>


<!-- Modal -->
<div class="modal fade" id="AddModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
      <div class="modal-content">
        <form id="addform" method="post" action="<?php echo e(url('/app') . '/' . Request::segment(2) .'/insert_parks'); ?>" enctype="multipart/form-data">
          <?php echo e(csrf_field()); ?>

          <div class="modal-header">
            
            <?php if('corvallis' == Request::segment(2)): ?>
                <h5 class="card-title">Add Parks Entertainment</h5>
            <?php endif; ?>
            <?php if('lebanon' == Request::segment(2)): ?>
                <h5 class="card-title">Add Parks Trails</h5>
            <?php endif; ?>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true close-btn">×</span>
            </button>
          </div>
          <div class="modal-body">
            <div class="form-group">
              <label for="addInput1">Select Image * <span style="color:red;" class="err_msg"></span></label>
              <input type="file" accept="image/*" class="form-control-file my_image" name="image" id="addInput1" style="opacity: unset; position: unset">

            </div>
            <div class="form-group">
              <label for="addInput2">Title *</label>
              <textarea id="addInput2" name="title" class="form-control" cols="2"></textarea>
            </div>

            <div class="form-group">
              <label for="addInput3">Category</label>
              <select name="category_id" id="" class="form-control">
                <option value="">Select One</option>
                <?php $__currentLoopData = $category; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($value->id); ?>"><?php echo e($value->name); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </select>
            </div>
            <div class="form-group">
              <label for="addInput41">Description</label>
              <textarea id="addInput41" name="description" class="form-control"></textarea>
            </div>
            <div class="form-group">
              <label for="addInput5">Latitude </label>
              <input type="text" class="form-control" name="latitude" id="addInput5" maxlength="23">
            </div>
            <div class="form-group">
              <label for="addInput5">Longitude</label>
              <input type="text" class="form-control" name="longitude" id="addInput5" maxlength="24">
            </div>
            <div class="form-group">
              <label for="addInput6">Phone</label>
              <input type="text" class="form-control" name="phone" id="addInput6" >
            </div>
            <div class="form-group">
              <label for="addInput5">Url</label>
              <input type="url" class="form-control" name="url" id="addInput5">
            </div>
            <div class="form-group">
              <label for="addInput11">Video Url</label>
              <input type="url" class="form-control" name="video_url" id="addInput11">
            </div>
            <div class="form-group">
              <label for="addInput5">Facebook Url</label>
              <input type="url" class="form-control" name="facebook_url" id="addInput5">
            </div>
            <div class="form-group">
              <label for="addInput112">Instagram Url</label>
              <input type="url" class="form-control" name="instagram_url" id="addInput112">
            </div>

            <div class="form-group">
              <label for="addInput112">Twitter Url</label>
              <input type="url" class="form-control" name="twitter_url" id="addInput112">
            </div>


            <div class="form-group">
              <label for="addInput7">Address</label>
              <input type="text" class="form-control" name="address" id="addInput7">
            </div>
            <div class="form-group">
              <label for="addInput2">Status</label>
              <select name="directory_status" class="form-control">
                <option value="active">Active</option>
                <option value="inactive">Inactive</option>
              </select>
            </div>

            <div class="form-group">
              <label for="addInput12">Order</label>
              <input type="text" class="form-control" name="order_num" id="addInput12" maxlength="4" >
            </div>
          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-secondary close-btn" data-dismiss="modal">Close</button>
            <button type="submit" id="submit" class="btn btn-primary">Submit</button>
          </div>
        </form>
      </div>
    </div>
</div>

  <!--  edit Modal -->
  <div class="modal fade" id="editModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
      <div class="modal-content">
        <form id="editform" method="post" action="<?php echo e(url('/app') . '/' . Request::segment(2) .'/update_parks'); ?>" enctype="multipart/form-data">
          <?php echo e(csrf_field()); ?>

          <div class="modal-header">
            
            <?php if('corvallis' == Request::segment(2)): ?>
                 <h5 class="card-title">Edit Parks Entertainment</h5>
            <?php endif; ?>
            <?php if('lebanon' == Request::segment(2)): ?>
                <h5 class="card-title">Edit Parks Trails</h5>
            <?php endif; ?>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true close-btn">×</span>
            </button>
          </div>
          <div class="modal-body">
            <div class="form-group">
              <label for="addInput1">Select Image <span style="color:red;" class="err_msg"></span></label>
              <input type="file" accept="image/*" class="form-control-file my_image" name="image" id="addInput1" style="opacity: unset; position: unset">
            </div>
            <div class="form-group">
              <label for="addInput2">Title *</label>
              <textarea id="title" name="title" class="form-control" cols="2"></textarea>
            </div>
            <div class="form-group">
              <label for="addInput3">Category</label>
              <select name="category_id" id="category_id" class="form-control">
                <option value="none" selected>None</option>
                <?php $__currentLoopData = $category; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($value->id); ?>"><?php echo e($value->name); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </select>
            </div>
            <div class="form-group">
              <label for="addInput41">Description</label>
              <textarea id="description" name="description" class="form-control"></textarea>
            </div>
            <div class="form-group">
              <label for="addInput5">Url</label>
              <input type="url" class="form-control" name="url" id="url">
            </div>
            <div class="form-group">
              <label for="addInput5">Latitude </label>
              <input type="text" class="form-control" name="latitude" id="latitude" maxlength="23">
            </div>
            <div class="form-group">
              <label for="addInput5">Longitude</label>
              <input type="text" class="form-control" name="longitude" id="longitude" maxlength="24">
            </div>
            <div class="form-group">
              <label for="addInput6">Phone</label>
              <input type="text" class="form-control" name="phone" id="phone" >
            </div>
            <div class="form-group">
              <label for="addInput7">Address</label>
              <input type="text" class="form-control" name="address" id="address">
            </div>
            <div class="form-group">
              <label for="addInput11">Video Url</label>
              <input type="url" class="form-control" name="video_url" id="video_url">
            </div>
            <div class="form-group">
              <label for="addInput5">Facebook Url</label>
              <input type="url" class="form-control" name="facebook_url" id="facebook_url">
            </div>
            <div class="form-group">
              <label for="addInput112">Instagram Url</label>
              <input type="url" class="form-control" name="instagram_url" id="instagram_url">
            </div>
            <div class="form-group">
              <label for="addInput112">Twitter Url</label>
              <input type="url" class="form-control" name="twitter_url" id="twitter_url">
            </div>

            <div class="form-group">
              <label for="addInput2">Status</label>
              <select name="directory_status" id="directory_status" class="form-control">
                <option value="active">Active</option>
                <option value="inactive">Inactive</option>
              </select>
            </div>

            <div class="form-group">
              <label for="addInput12">Order</label>
              <input type="text" class="form-control" name="order_num" id="order_num" maxlength="4" >
            </div>
          </div>
          <input type="hidden" name="dir_id" id="dir_id">
          <div class="modal-footer">
            <button type="button" class="btn btn-secondary close-btn" data-dismiss="modal">Close</button>
            <button type="submit" class="btn btn-primary">Save change</button>
          </div>
        </form>
      </div>
    </div>
</div>



<script>
    $(document).ready(function() {
      // Fill Edit data
      $(document).on('click', '.edit', function() {
        $("#editform").find('.has-error').removeClass("has-error");
        $("#editform").find('.has-success').removeClass("has-success");
        $("#editform").find('.err_msg').text("");
        $('#editform').find('.form-control-feedback').remove();
        var id = $(this).data('id');
        var name = $(this).data('name');
        $.ajax({
          type: 'POST',
          url: "<?php echo e(url ('/app') . '/' . Request::segment(2) .'/parkget'); ?>",
          headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
          },
          data: {
            'id': id,
            'name': name
          },
          success: function(data) {
            if (data) {
              $('#dir_id').val(data.id);
              $('#title').val(data.title);
              $('#category_id').val(data.category_id);
              $('#url').val(data.url);
              $('#facebook_url').val(data.facebook_url);
              $('#video_url').val(data.video_url);
              $('#instagram_url').val(data.instagram_url);
              $('#twitter_url').val(data.twitter_url);
              $('#phone').val(data.phone);
              $('#latitude').val(data.latitude);
              $('#longitude').val(data.longitude);
              $('#address').val(data.address);
              $('#directory_status').val(data.directory_status);
              $('#order_num').val(data.order_num);
              $('#description').val(data.description);
              var cat = $('#category_id').val();
              if (cat == null) {
                $('#category_id').val('none').attr('selected', true)
              } else {
                $('#category_id').val(data.category_id).attr('selected', true)
              }
              $('#editModal').modal('show');
            }
          }
        });
      });
      $('#addform').validate({
        rules: {
          image: {
            required: true,
          },
          title: {
            required: true,
          },
          latitude: {
            latCoord: true
          },
          longitude: {
            longCoord: true
          },
          url: {
            complete_url: true
          },
          video_url: {
            complete_url: true
          },
          facebook_url: {
            complete_url: true
          },
          instagram_url: {
            complete_url: true
          },
          twitter_url: {
            complete_url: true
          },

          phone: {
            numericdashe: true
          }

        },
        messages: {
          image: {
            required: "This field is required",
          },
          title: {
            required: "This field is required"
          }

        },
        errorPlacement: function(error, element) {
          element.closest("div").addClass('has-error');
        },
        success: function(error, element) {
          $(element).closest("div").removeClass('has-error');
        }
      });
      $('#editform').validate({
        rules: {
          title: {
            required: true,
          },
          latitude: {
            latCoord: true
          },
          longitude: {
            longCoord: true
          },
          url: {
            complete_url: true
          },
          video_url: {
            complete_url: true
          },
          facebook_url: {
            complete_url: true
          },
          instagram_url: {
            complete_url: true
          },
          twitter_url: {
            complete_url: true
          },

          phone: {
            numericdashe: true
          }
        },
        messages: {
          title: {
            required: "This field is required"
          }

        },
        errorPlacement: function(error, element) {
          element.closest("div").addClass('has-error');
        },
        success: function(error, element) {
          $(element).closest("div").removeClass('has-error');
        }
      });
      jQuery.validator.addMethod("complete_url", function(val, elem) {
        if (val.length == 0) {
          return true;
        }
        if (!/^(https?|ftp):\/\//i.test(val)) {
          val = 'http://' + val;
          $(elem).val(val);
        }
        return /^(https?|ftp):\/\/(((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&amp;'\(\)\*\+,;=]|:)*@)?(((\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5]))|((([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.)+(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.?)(:\d*)?)(\/((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&amp;'\(\)\*\+,;=]|:|@)+(\/(([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&amp;'\(\)\*\+,;=]|:|@)*)*)?)?(\?((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&amp;'\(\)\*\+,;=]|:|@)|[\uE000-\uF8FF]|\/|\?)*)?(\#((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&amp;'\(\)\*\+,;=]|:|@)|\/|\?)*)?$/i.test(val);
      });
      $.validator.addMethod('latCoord', function(value, element) {
        console.log(this.optional(element))
        return this.optional(element) ||
          value.length >= 4 && /^(?=.)-?((8[0-5]?)|([0-7]?[0-9]))?(?:\.[0-9]{1,20})?$/.test(value);
      });

      $.validator.addMethod('longCoord', function(value, element) {
        console.log(this.optional(element))
        return this.optional(element) ||
          value.length >= 4 && /^(?=.)-?((0?[8-9][0-9])|180|([0-1]?[0-7]?[0-9]))?(?:\.[0-9]{1,20})?$/.test(value);
      });
      jQuery.validator.addMethod("numericdashe", function(value, element) {
        return this.optional(element) ||
          value.length >= 4 && /^[0-9\-\+]+$/i.test(value.replace(/[\s()+\-\.]|ext/gi, ''));

      });
    });

     // delete
    $(document).on('click', '.delete', function() {
        if (confirm("Are you sure You want to delete it?")) {
          var id = $(this).data('id');
          var name = $(this).data('name');
          $.ajax({
            type: 'POST',
            url: "<?php echo e(url ('/app') . '/' . Request::segment(2) .'/deletepark'); ?>",
            headers: {
              'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            data: {
              'id': id,
              'name': name
            },
            success: function(data) {
              if (data) {
                alert("Delete successfully.");
                window.location.reload();
              } else {
                alert("Somthing went wrong.");
              }
            }
          });
        }
    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\chamber-ddd\resources\views/parks/index.blade.php ENDPATH**/ ?>