<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8" />

  <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1" />
  <title>
    <?php echo $__env->yieldContent('title'); ?>
  </title>
  <meta content='width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0, shrink-to-fit=no' name='viewport' />
  <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>" />

  <link rel="icon" href="<?php echo e(asset('assets')); ?>/logo/logo-<?php echo e(appName(Request())); ?>.png">
  <link href="https://fonts.googleapis.com/css?family=Montserrat:400,700,200" rel="stylesheet" />

  <link href="<?php echo e(asset('assets/css/bootstrap.min.css')); ?>" rel="stylesheet" />
  <link href="<?php echo e(asset('assets/css/paper-dashboard.css?v=2.0.1')); ?>" rel="stylesheet" />
  <link href="<?php echo e(asset('assets/css/style.css')); ?>" rel="stylesheet" />
  <link rel="stylesheet" type="text/css" href="//cdn.datatables.net/1.10.12/css/jquery.dataTables.min.css">
  <link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />

  <script src="<?php echo e(asset('assets/js/core/jquery.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/core/popper.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/core/bootstrap.min.js')); ?>"></script>
<script src="https://cdn.datatables.net/1.10.23/js/jquery.dataTables.min.js"></script>
<script type="text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
<script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>

<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.19.2/jquery.validate.min.js" integrity="sha512-UdIMMlVx0HEynClOIFSyOrPggomfhBKJE28LKl8yR3ghkgugPnG6iLfRfHwushZl1MOPSY6TsuBDGPK2X4zYKg==" crossorigin="anonymous"></script>
<script>
     function clearUser() {
    $('.form-control').val('');
    $('.form-control-file').val('');
    $("#addform").validate().resetForm();
    $("#addform").find('.has-error').removeClass("has-error");
    $("#addform").find('.err_msg').text("");
    $("#addform").find('.has-success').removeClass("has-success");
  }
   $(document).ready(function() {
    $('#example').DataTable();
   });
</script>
</head>

<style>
    .has-error {
    color: red;
  }


  div#example_length {
    padding-bottom: 15px;
  }

  #example_length select {
    width: 45px;
    height: 28px;
    margin: 0px 10px;
    text-align: center;
    border-radius: 6px;
    padding-left: 4px;
    border: 1px solid #0000002e;
  }

  #example_length select:focus {
    outline: none;
  }

  div#example_filter {
    margin-right: 32px;
    font-size: 21px;
  }

  #example_filter input[type="search"] {
    height: 30px;
    border: 1px solid #00000029;
    width: 340px;
    border-radius: 23px;
    padding: 16px;

  }

  input[type="search"]:focus {
    outline: none;
  }
     table.dataTable.no-footer {
    border-bottom: 0px solid #111;
    padding-bottom: 20px;
    text-align: center;
  }

  table.dataTable thead th,
  table.dataTable thead td {
    padding: 10px 18px;
    border-bottom: 0px solid #d8d8d8;
  }
</style>

<body class="main-body" >
  <div class="wrapper ">
    <div class="sidebar" data-color="white" data-active-color="danger">
      <div class="logo">

        <a href="#" class="simple-text logo-normal">
          <div class="logo-image-big text-center">
            <img src="<?php echo e(asset('assets').'/logo/logo-'.appName(Request()). '.png'); ?>" height="90" width="160">
          </div>
        </a>
      </div>
      <div class="sidebar-wrapper">
        <ul class="nav">
          <li class="<?php echo e((request()->is('/')) ? 'active' : ''); ?>">
            <a href="<?php echo e(url('/app/' . appName(Request()) . '/')); ?>">
              <i class="nc-icon nc-bank"></i>
              <b><?php echo e(config('global.'.appName(Request()) .'.dashboard')); ?></b>
            </a>
          </li>
          <li class="<?php echo e((request()->is('accounts')) ? 'active' : ''); ?>">
            <a href="<?php echo e(url('/app/' .appName(Request()). '/accounts' )); ?>">
              <i class="nc-icon nc-single-02 "></i>
              <b> <?php echo e(config('global.'.appName(Request()) .'.accounts')); ?></b>
            </a>
          </li>
          <li class="<?php echo e((request()->is('events')) ? 'active' : ''); ?>">
                <a href="<?php echo e(url('/app/' .appName(Request()). '/events' )); ?>">
                    <i class="nc-icon nc-pin-3"></i>
                <b><?php echo e(config('global.'.appName(Request()) .'.events')); ?></b>
                </a>
          </li>

          <li class="<?php echo e((request()->is('ads')) ? 'active' : ''); ?>">
            <a href="<?php echo e(url('/app/' .appName(Request()). '/ads' )); ?>">
              <i class="nc-icon nc-map-big"></i>
              <b><?php echo e(config('global.'.appName(Request()) .'.ads')); ?></b>
            </a>
          </li>

          <li class="<?php echo e((request()->is('/park_category')) ? 'active' : ''); ?>">

                <a href="<?php echo e(url('/app/' .appName(Request()). '/park-category' )); ?>">
                <i class="nc-icon nc-diamond"></i>
                <b><?php echo e(config('global.'.appName(Request()) .'.directory_category')); ?></b>
              </a>
          </li>
          <li class="<?php echo e((request()->is('parks')) ? 'active' : ''); ?>">
            <a href="<?php echo e(url('/app/' .appName(Request()). '/park' )); ?>">
                <i class="nc-icon nc-single-copy-04"></i>
                <b><?php echo e(config('global.'.appName(Request()) .'.directory')); ?></b>
              </a>
          </li>



          <li class="<?php echo e((request()->is('category')) ? 'active' : ''); ?>">
            <a href="<?php echo e(url('/app/' .appName(Request()). '/category' )); ?>">
              <i class="nc-icon nc-diamond"></i>
              <b><?php echo e(config('global.'.appName(Request()) .'.category')); ?></b>
            </a>
          </li>

          <li class="<?php echo e((request()->is('explore')) ? 'active' : ''); ?>">

                <a href="<?php echo e(url('/app/' .appName(Request()). '/explore' )); ?>">
                <i class="nc-icon nc-single-copy-04"></i>
                <b><?php echo e(config('global.'.appName(Request()) .'.map_directory')); ?></b>
                </a>
          </li>

          <li class="<?php echo e((request()->is('resource')) ? 'active' : ''); ?>">
            <a href="<?php echo e(url('/resource')); ?>">
              <i class="nc-icon nc-single-copy-04"></i>
              <b><?php echo e(config('global.'.appName(Request()) .'.resource')); ?></b>
            </a>
          </li>
        </ul>
      </div>
    </div>
    <div class="main-panel">

      <nav class="navbar navbar-expand-lg navbar-absolute fixed-top navbar-transparent">
        <div class="container-fluid">
          <div class="navbar-wrapper">
            <div class="navbar-toggle">
              <button type="button" class="navbar-toggler">
                <span class="navbar-toggler-bar bar1"></span>
                <span class="navbar-toggler-bar bar2"></span>
                <span class="navbar-toggler-bar bar3"></span>
              </button>
            </div>
            <a class="navbar-brand" href="javascript:;"><?php echo $__env->yieldContent('title'); ?></a>
          </div>
          <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navigation" aria-controls="navigation-index" aria-expanded="false" aria-label="Toggle navigation">
            <span class="navbar-toggler-bar navbar-kebab"></span>
            <span class="navbar-toggler-bar navbar-kebab"></span>
            <span class="navbar-toggler-bar navbar-kebab"></span>
          </button>
          <div class="collapse navbar-collapse justify-content-end" id="navigation">

            <ul class="navbar-nav">

              <li class="nav-item btn-rotate dropdown">
                <a class="nav-link dropdown-toggle" href="#" id="navbarDropdownMenuLink" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">

                </a>
                <div class="dropdown-menu dropdown-menu-right" aria-labelledby="navbarDropdownMenuLink">
                  <a class="dropdown-item" href="<?php echo e(url('/app/' . appName(Request()) . '/logout')); ?>">Logout</a>

                </div>
              </li>

            </ul>
          </div>
        </div>
      </nav>
<?php /**PATH C:\xampp\htdocs\chamber-ddd\resources\views/layouts/header.blade.php ENDPATH**/ ?>