<?php
namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\DirectoryCategory;
use DB;
use App\Http\Traits\DirectoryCategoryTraits;


class DirectoryCategoryController extends Controller
{
    use DirectoryCategoryTraits;

    public function getDirectoryCategoryList(Request $request)
    {
        $DirectoryCategory = $this->selectAllDirectoryCategory($request);

        return response()->json(['status' => 'success', 'message' => 'directory category found successfully', 'data' => $DirectoryCategory]);
    }


    public function getDirCateDetails($appName,$category_id)
    {
        $get_details = $this->getDirectoryCategoryDetail($category_id);

        if($get_details){
            return response()->json(["status" => "success", "message" => "", "data" => $get_details]);
        }else{
            return response()->json(["status" => "error", "message" => config('globalMessages.edit_directory_category_detail_error')]);
        }
    }

    public function deleteDirectoryCategory(Request $request)
    {
        $getDirCat = $this->dirCategoryDelete($request);
        if($getDirCat){
            return response()->json(['status' => 'success', 'message' => config('globalMessages.delete_directory_category_success_message')]);
        }else{
            return response()->json(['status' => 'error', 'message' => config('globalMessages.delete_directory_category_error_message')]);
        }
    }

}

