<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\ResourceCategory;
use App\Http\Traits\ResourceCategoryTraits;

class ResourceCategoryController extends Controller
{
    use ResourceCategoryTraits;

    public function getResourceCategoryList()
    {
        $ResourceCategory = $this->selectAllResCategory();
        return response()->json(['status' => 'success', 'message' => 'resource category found successfully', 'data' => $ResourceCategory]);
    }

    public function getResourceCategoryDetails($app_name,$res_cat_id)
    {
        $getResCategory = $this->getResCategoryDetail($res_cat_id);

        if($getResCategory){
            return response()->json(["status" => "success", "message" => "", "data" => $getResCategory]);
        }else{
            return response()->json(["status" => "error", "message" => config('globalMessages.edit_resource_category_detail_error')]);
        }

    }

    public function deleteResourceCategory(Request $request)
    {
        $getResCat = $this->resCategoryDelete($request);
        if($getResCat){
            return response()->json(['status' => 'success', 'message' => config('globalMessages.delete_resource_category_success_message')]);
        }else{
            return response()->json(['status' => 'error', 'message' => config('globalMessages.delete_resource_category_error_message')]);
        }
    }
}
