<?php
namespace App\Http\Traits;
use App\Models\Ads;
use DB;

trait AdsTraits {

    public function getAllAds()
    {
        return Ads::all();
    }

    public function selectAllAds()
    {
        return Ads::select('*',DB::raw("CONCAT('".env('APP_URL')."/',image_path) as image_path"))->where('ads_status', 'active')
        ->where('expiration', '>=', date('Y-m-d'))
        ->orderBy('order_num', 'asc')
        ->get();
    }

    public function getAdsDetail($ads_id)
    {
        return Ads::find($ads_id);
    }

    public function createAds($request)
    {
        return Ads::create($request->all());
    }

    public function updateAds($request)
    {
        $ads_id = $request->get('ads_id');

        $arr = $request->all();
        unset($arr['_token']);
        unset($arr['ads_id']);

        $currentImagePath = $this->getImagePath($ads_id);
        $image_path = "";
        if ($request->hasFile('image')) {
            $request->validate([
                'image' => 'required|image|mimes:jpeg,png,jpg,gif,svg|dimensions:width=760,height=190',
            ]);
            $image_path = storeImage($request,$request->image,'ads');
        }

        $arr = array_merge($arr,['expiration' => date('Y-m-d ', strtotime($request->expiration))]);
        if($image_path != ""){
            $arr = array_merge($arr,['image_path' => $image_path]);
        }
        unset($arr['image']);


        $editAds= Ads::where('id',$ads_id)->update($arr);
        if($image_path != "" && $currentImagePath != ""){
            if(file_exists($currentImagePath)){
                unlink($currentImagePath);
            }
        }

        return $editAds;
    }

    public function getImagePath($ads_id)
    {
        $image_path = "";

        $ads = Ads::find($ads_id);
        if($ads){
            $image_path = $ads->image_path;
        }

        return $image_path;
    }


    public function adsDelete($request)
    {
        $ads_id = $request->get('ads_id');
        return Ads::where('id',$ads_id)->delete();
    }
}
