<?php
namespace App\Http\Traits;
use App\Models\MapDirectory;
use DB;

trait MapDirectoryTraits {

    public function getAllMapDirectory()
    {
        return MapDirectory::all();
    }

    public function selectAllMapDirectory($category_id)
    {
        return  DB::table('map_directory as m')
        ->select('m.*', 'c.name as category_name', 'c.image_path as cat_image',
        DB::raw("CONCAT('".env('APP_URL')."/',m.image_path) as image_path"),
        DB::raw("CONCAT('".env('APP_URL')."/',c.image_path) as cat_image"))
        ->leftJoin('categories as c', 'c.id', '=', 'm.category_id')
        ->orWhere(function($query) use($category_id){
            if($category_id != ""){
                $query->where('m.category_id', $category_id);
            }
        })
        ->where('m.explore_status', '=', 'active')
        ->where('m.deleted_at', '=', null)
        ->orderBy('m.order_num', 'asc')
        ->get();
    }

    public function getMapDirectoryDetail($map_directory_id)
    {
        return MapDirectory::find($map_directory_id);
    }

    public function createMapDirectory($request)
    {
        return MapDirectory::create($request->all());
    }

    public function updateMapDirectory($request)
    {
        $map_directory_id = $request->get('map_directory_id');

        $arr = $request->all();
        unset($arr['_token']);
        unset($arr['map_directory_id']);

        $currentImagePath = $this->getImagePath($map_directory_id);
        $image_path = "";
        if ($request->hasFile('image')) {
            $image_path = storeImage($request,$request->image,'map_directory');
        } else {
            $image_path = '';
        }

        if($image_path != ""){
            $arr = array_merge($arr,['image_path' => $image_path]);
        }
        unset($arr['image']);

        $mapdirectory= MapDirectory::where('id',$map_directory_id)->update($arr);
            if($image_path != "" && $currentImagePath != ""){
                if(file_exists($currentImagePath)){
                    unlink($currentImagePath);
                }
            }
        return $mapdirectory;
    }

    public function getImagePath($map_directory_id)
    {
        $image_path = "" ;
        $map_directory = MapDirectory::find($map_directory_id);
        if($map_directory){
            $image_path = $map_directory->image_path;
        }

        return $image_path;
    }

    public function mapDirectoryDelete($request)
    {
        $map_directory_id = $request->get('map_directory_id');
        return MapDirectory::where('id',$map_directory_id)->delete();
    }
}
