<?php
namespace App\Http\Traits;
use App\Models\ResourceCategory;
use DB;

trait ResourceCategoryTraits {

    public function getAllResourceCategory()
    {
        return ResourceCategory::all();
    }

    public function selectAllResCategory(Type $var = null)
    {
        return ResourceCategory::select('*',DB::raw("CONCAT('".env('APP_URL')."/',image_path) as image_path"))
        ->where('category_status','active')->get();
    }

    public function getResCategoryDetail($res_cat_id)
    {
       return ResourceCategory::find($res_cat_id);
    }

    public function CreateResCategory($request)
    {
        return ResourceCategory::create($request->all());
    }

    public function updateResCategory($request)
    {
        $res_cat_id = $request->get('res_cat_id');

        $arr = $request->all();
        unset($arr['_token']);
        unset($arr['res_cat_id']);

        $currentImagePath = $this->getImagePath($res_cat_id);
        $image_path = "";
        if ($request->hasFile('image')) {
            $image_path = storeImage($request,$request->image,'resource_category');
        } else {
            $image_path = '';
        }

        if($image_path != ""){
            $arr = array_merge($arr,['image_path' => $image_path]);
        }
        unset($arr['image']);

        $resCategory= ResourceCategory::where('id',$res_cat_id)->update($arr);
        if($image_path != "" && $currentImagePath != ""){
            if(file_exists($currentImagePath)){
                unlink($currentImagePath);
            }
        }

        return $resCategory;
    }

    public function getImagePath($res_cat_id)
    {
        $image_path = "";
        $resCategory = ResourceCategory::find($res_cat_id);
        if($resCategory){
            $image_path = $resCategory->image_path;
        }

        return $image_path;
    }

    public function resCategoryDelete($request)
    {
        $res_cat_id = $request->get('res_cat_id');
        return ResourceCategory::where('id',$res_cat_id)->delete();
    }
}
