<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Ads extends Model
{
    use SoftDeletes;

    protected $table = 'ads';

    protected $fillable = [
        'id',
        'image_path',
        'url',
        'expiration',
        'ads_status',
        'order_num',
        'deleted_at',
        'created_at',
        'updated_at'
    ];

    protected $casts = [
        'id' => 'integer',
        'image_path' => 'string',
        'url' => 'string',
        'expiration' => 'date',
        'ads_status' => 'string',
        'order_num' => 'integer',
        'deleted_at' => 'timestamp',
        'created_at' => 'datetime',
        'updated_at' => 'datetime'
    ];



    public function adsClick(): \Illuminate\Database\Eloquent\Relations\HasMany
    {
        return $this->hasMany('App\Models\AdsClick', 'ads_id', 'id');
    }

}
