<?php

namespace App\Models;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;



class Category extends Model
{
    use softDeletes;
    protected $table = 'categories';

    protected $fillable = [
        'id',
        'image_path',
        'name',
        'category_status',
        'order_num',
        'created_at',
        'updated_at'
    ];

    protected $casts = [
        'id' => 'integer',
        'image_path' => 'string',
        'password' => 'string',
        'name' => 'string',
        'category_status' => 'string',
        'order_num' => 'integer',
        'created_at' => 'datetime',
        'updated_at' => 'datetime'
    ];
}
