<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;


class Resource extends Model
{
    use HasFactory,SoftDeletes;

    protected $table = 'resource';

    protected $fillable = [
        'id',
        'image_path',
        'category_id',
        'title',
        'description',
        'facebook_url',
        'instagram_url',
        'video_url',
        'url',
        'address',
        'latitude',
        'longitude',
        'phone',
        'resource_status',
        'order_num',
        'created_at',
        'updated_at',
    ];

    protected $casts = [
        'id' => 'integer',
        'image_path' => 'string',
        'category_id' => 'integer',
        'title' => 'string',
        'description' => 'string',
        'facebook_url' => 'string',
        'instagram_url' => 'string',
        'video_url' => 'string',
        'url' => 'string',
        'address' => 'string',
        'phone' => 'string',
        'latitude' => 'string',
        'longitude' => 'string',
        'resource_status' => 'string',
        'order_num' => 'integer',
        'created_at' => 'datetime',
        'updated_at' => 'datetime'
    ];


}
