<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('technical_assistances', function (Blueprint $table) {
            $table->id();
            $table->integer('category_id');
            $table->string('image_path',199);
            $table->text('description');
            $table->text('url');
            $table->text('survey_url');
            $table->text('video_url');
            $table->string('phone',15);
            $table->enum('assistance_status',['active','inactive'])->default('active');
            $table->integer('order_num');
            $table->softDeletes();
            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->useCurrent()->useCurrentOnUpdate();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('technical_assistances');
    }
};
