<!DOCTYPE html>
<html lang="en">

<head>
    <title>Login | {{ ucfirst(appName(Request())  )}}</title>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <!--===============================================================================================-->
    <link rel="icon" href="{{asset('assets')}}/logo/logo-{{appName(Request())}}.png">
    <!--===============================================================================================-->
    <link rel="stylesheet" type="text/css" href="{{asset('assets/login/vendor/bootstrap/css/bootstrap.min.css')}}">
    <link rel="stylesheet" type="text/css" href="{{asset('assets/login/fonts/font-awesome-4.7.0/css/font-awesome.min.css')}}">
    <link rel="stylesheet" type="text/css" href="{{asset('assets/login/vendor/animate/animate.css')}}">

    <link rel="stylesheet" type="text/css" href="{{asset('assets/login/css/util.css')}}">
    <link rel="stylesheet" type="text/css" href="{{asset('assets/login/css/main.css')}}">
    <link rel="stylesheet" type="text/css" href="{{asset('assets/css/custom.css')}}">

</head>

<body>

    <div class="limiter">

        <div class="container-login100">
            <div class="wrap-login100 p-t-85 p-b-20">
                    @if(session()->get('error'))
                    <div class="col-md-3"></div>
                    <div class="col-md-12">
                        <div class="alert alert-danger">
                            <strong>Error!</strong> {{session()->get('error')}}
                        </div>
                    </div>

                    @endif
                <form class="login100-form validate-form" method="POST" action="{{ url('app/' . appName(Request()) . '/post-login' )  }}" id="login-form">
                    @csrf
                    <span class="login100-form-avatar">
                        <img src="{{asset('app-config/' .appName(Request()) . '/' . 'logo-'.appName(Request()). '.png' )}}" height="90" width="160" alt="logo-{{appName(Request())}}">
                    </span>
                    <span class="login100-form-title m-t-50">
                        Welcome
                    </span>
                    <div class="m-b-35">
                        <div class="wrap-input100 -input m-t-50 show-email-error" data-validate="Enter Email">
                            <input id="text" class="input100 has-val" type="text" name="email">
                            <span class="focus-input100" data-placeholder="Email/Username"></span>
                        </div>
                    </div>

                    <div class="m-b-50">
                        <div class="wrap-input100 validate-input show-password-error" data-validate="Enter password">
                            <input id="password" class="input100 has-val" type="password" name="password">
                            <span class="focus-input100" data-placeholder="Password"></span>
                        </div>
                    </div>

                    <div class="container-login100-form-btn">
                        <button type="submit" class="login100-form-btn">
                            Login
                        </button>
                    </div>

                    <ul class="login-more p-t-100">
                        <li class="m-b-8">
                            <span class="txt1">
                                Forgot
                            </span>
                            <a href="{{ url( baseRedirectUrl(Request()) . '/forgot-password' ) }}" class="txt2">
                                Password?
                            </a>
                        </li>
                    </ul>
                </form>
            </div>
        </div>
    </div>

    <!--===============================================================================================-->
    <script src="{{asset('assets/login/vendor/jquery/jquery-3.2.1.min.js')}}"></script>
    <script src="{{asset('assets/login/js/main.js')}}"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.19.3/jquery.validate.min.js" integrity="sha512-37T7leoNS06R80c8Ulq7cdCDU5MNQBwlYoy1TX/WUsLFC2eYNqtKlV0QjH7r8JpG/S0GUMZwebnVFLPd6SU5yg==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
    <script>
        $('#login-form').validate({
            rules:{
                email:{
                    required: true
                },
                password:{
                    required: true
                }
            },
            messages:{
                email:{
                    required: "{{ config('globalMessages.required_message.email_username') }}"
                },
                password:{
                    required: "{{ config('globalMessages.required_message.password') }}"
                }
            },
            errorPlacement: function(error, element) {
                var name = $(element).attr("name");
                if (name == "email") {
                    error.insertAfter('.show-email-error');
                } else if(name == "password"){
                    error.insertAfter('.show-password-error');
                } else {
                    error.insertAfter(element);
                }
            }
        })
    </script>
</body>
</html>
