<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8" />

  <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1" />
  <title> {{ ucfirst(appName(Request())) }} </title>
  <meta content='width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0, shrink-to-fit=no' name='viewport' />
  <meta name="csrf-token" content="{{ csrf_token() }}" />

  <link rel="icon" href="{{asset('app-config/' .appName(Request()) . '/' . 'logo-'.appName(Request()). '.png' )}}">
  <link href="https://fonts.googleapis.com/css?family=Montserrat:400,700,200" rel="stylesheet" />

  <link href="{{asset('assets/css/bootstrap.min.css')}}" rel="stylesheet" />
  <link href="{{asset('assets/css/paper-dashboard.css?v=2.0.1')}}" rel="stylesheet" />
  <link href="{{asset('assets/css/style.css')}}" rel="stylesheet" />
  <link href="{{asset('assets/css/custom.css')}}" rel="stylesheet" />
  <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.11.5/css/jquery.dataTables.min.css">
  <link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">



</head>

<body class="main-body" >
  <div class="wrapper ">
    <div class="sidebar" data-color="white" data-active-color="danger">
      <div class="logo">

        <a href="#" class="simple-text logo-normal">
          <div class="logo-image-big text-center">
            <img src="{{asset('app-config/' .appName(Request()) . '/' . 'logo-'.appName(Request()). '.png' )}}" height="90" width="160">
          </div>
        </a>
      </div>
      <div class="sidebar-wrapper">
        <ul class="nav">

            @if(count(getSideBar(Request())) > 0)
                @foreach(getSideBar(Request()) as $menu_items)
                    @if($menu_items['route'] != "app-config")
                    <li class="{{ (request()->is(baseRedirectUrl(Request()) . '/' . $menu_items['route'])) ? 'active' : '' }}">
                        <a href="{{ url(baseRedirectUrl(Request()) . '/' . $menu_items['route']) }}">
                            <i class="{{ $menu_items['icon']  }}"></i>
                            <b>{{ $menu_items['name'] }}</b>
                        </a>
                    </li>
                    @endif
                    @if(session()->get('user_email') != null && session()->get('user_email') == "dilip@digimonksolusions.com" )
                        @if ($menu_items['route'] == "app-config")
                        <li class="{{ (request()->is(baseRedirectUrl(Request()) . '/' . $menu_items['route'])) ? 'active' : '' }}">
                            <a href="{{ url(baseRedirectUrl(Request()) . '/' . $menu_items['route']) }}">
                                <i class="{{ $menu_items['icon']  }}"></i>
                                <b>{{ $menu_items['name'] }}</b>
                            </a>
                        </li>
                        @endif
                    @endif
                @endforeach
            @endif

        </ul>
      </div>
    </div>
    <div class="main-panel">

      <nav class="navbar navbar-expand-lg navbar-absolute fixed-top navbar-transparent">
        <div class="container-fluid">
          <div class="navbar-wrapper">
            <div class="navbar-toggle">
              <button type="button" class="navbar-toggler">
                <span class="navbar-toggler-bar bar1"></span>
                <span class="navbar-toggler-bar bar2"></span>
                <span class="navbar-toggler-bar bar3"></span>
              </button>
            </div>
            <a class="navbar-brand" href="javascript:;">@yield('title')</a>
          </div>
          <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navigation" aria-controls="navigation-index" aria-expanded="false" aria-label="Toggle navigation">
            <span class="navbar-toggler-bar navbar-kebab"></span>
            <span class="navbar-toggler-bar navbar-kebab"></span>
            <span class="navbar-toggler-bar navbar-kebab"></span>
          </button>
          <div class="collapse navbar-collapse justify-content-end" id="navigation">

            <ul class="navbar-nav">

              <li class="nav-item btn-rotate dropdown">
                  @if(session()->get('user'))
                    <a class="nav-link dropdown-toggle" href="#" id="navbarDropdownMenuLink" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                        {{ session()->get('user')->firstname . ' ' . session()->get('user')->lastname }}
                    </a>
                  @endif
                <div class="dropdown-menu dropdown-menu-right" aria-labelledby="navbarDropdownMenuLink">
                  <a class="dropdown-item" href="{{  url('/app/' . appName(Request()) . '/logout')  }}">Logout</a>
                </div>
              </li>

            </ul>
          </div>
        </div>
      </nav>
