
<?php $__env->startSection('title', 'Events'); ?>
<?php $__env->startSection('content'); ?>
<div class="content">
  <div class="row">
    <div class="col-md-12">
      <div class="card">
        <div class="card-header">
          <button type="button" class="btn btn-primary float-right" data-toggle="modal" data-target="#AddModal"> ADD </button>
          <h4 class="card-title"> Events List</h4>
          <?php if($message = Session::get('success')): ?>
          <div class="alert alert-success alert-block">
            <button type="button" class="close" data-dismiss="alert">×</button>
            <strong><?php echo e($message); ?></strong>
          </div>
          <?php endif; ?>

          <?php if($message = session()->get('error')): ?>
          <div class="alert alert-danger alert-block">
            <button type="button" class="close" data-dismiss="alert">×</button>
            <strong><?php echo e($message); ?></strong>
          </div>
          <?php endif; ?>
          <?php if(count($errors) > 0): ?>
          <div class="alert alert-danger">
            <button type="button" class="close" data-dismiss="alert">×</button>
            <strong>Error!</strong> There were some problems with your input.
            <ul>
              <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <li><?php echo e($error); ?></li>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
          </div>
          <?php endif; ?>
        </div>
        <div class="card-body">
          <div class="table-responsive">
            <table class="table" id="events-table">
              <thead class="text-primary">
                <th>#</th>
                <th>Images</th>
                <th>Title</th>
                <th>End Date</th>
                <th>Order</th>
                <th>Event Status</th>
                <th class="text-center">Action</th>
              </thead>
              <tbody>
                <?php $__currentLoopData = $events; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                  <td><?php echo e($loop->iteration); ?></td>
                  <td><img src="<?php echo e(url($row->image_path)); ?>" height="75" /></td>
                  <td><?php echo e($row->title); ?></td>
                  <td><?php echo e(\Carbon\Carbon::parse($row->end_date)->format('d-M-Y')); ?></td>
                  <td><?php echo e($row->order_num); ?></td>
                  <td><?php if($row->event_status == 'active'): ?>
                          Active
                      <?php else: ?>
                         In-Active
                      <?php endif; ?>
                </td>

                  <td class="text-center">
                    <div class="dropdown">
                      <button type="button" class="btn btn-primary dropdown-toggle" data-toggle="dropdown">
                        Action
                      </button>
                      <div class="dropdown-menu">
                          <a class="dropdown-item open-edit-modal"  data-id="<?php echo e($row->id); ?>" href="javascript:void(0)">Edit</a>
                          <a class="dropdown-item open-edit-delete" data-id="<?php echo e($row->id); ?>" href="javascript:void(0)">Delete</a>
                    </div>
                    </div>
                  </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<!-- Add modal -->
<?php echo $__env->make('event.modal.add-event-modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<!-- edit Modal -->
<?php echo $__env->make('event.modal.edit-event-modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('script-section'); ?>

    <script>
        $(document).ready(function() {
            $('#events-table').DataTable();
        });
        $('#addform').validate({
                rules: {
                    image: {
                        required: true,
                    },
                    title: {
                        required: true,
                    },
                    start_end_time: {
                        required: true,
                    },
                    phone: {
                        maxlength: 14,
                        numericdashe: true
                    },
                    url: {
                        complete_url: true
                    }
                },
                messages: {
                    image: {
                        required: "<?php echo e(config('globalMessages.required_message.image')); ?>",
                    },
                    title: {
                        required: "<?php echo e(config('globalMessages.required_message.title')); ?>"
                    },
                    start_end_time: {
                        required: "<?php echo e(config('globalMessages.required_message.start_end_time')); ?>"
                    }
                },

        });

        $('.open-edit-modal').on('click',function(){
            let event_id = $(this).data('id');
            $.ajax({
                method: "GET",
                url: "<?php echo e(url(baseRedirectUrl(Request()) . '/get-event-details')); ?>/" + event_id,
                success:function(data){
                    if (data.status != 'success') {
                        Swal.fire({
                            icon:'error',
                            title:"Error!",
                            text: data.message
                        })
                        return;
                    }
                    let print_data = data.data;

                    $('#e_start_end_time').daterangepicker({
                        timePicker: true,
                        autoApply: false,
                        startDate: moment().startOf('hour'),
                        endDate: moment().startOf('hour'),
                        minDate: new Date(),
                        locale: {
                            format: 'MM/DD/YYYY hh:mma',
                        },
                        autoclose: true,
                    });


                    $('#e_title').val(print_data.title);
                    $('#e_start_end_time').val(moment(print_data.start_date).format('MM-DD-Y H:mma') + ' - ' + moment(print_data.end_date).format('MM-DD-Y H:mma'));
                    $('#e_description').val(print_data.description);
                    $('#e_url').val(print_data.url);
                    $('#e_phone').val(print_data.phone);
                    $('#e_event_status').val(print_data.event_status);
                    $('#e_order_num').val(print_data.order_num);
                    $('#event_id').val(print_data.id);
                    $('#editModal').modal('show');
                },
                error:function(err){
                    console.log(err)
                }
            });

        });



        $('#editform').validate({
            rules: {
                title: {
                    required: true,
                },
                start_end_time: {
                    required: true
                },                phone: {
                    maxlength: 14,
                    numericdashe: true
                },
                url: {
                    complete_url: true
                }
            },            messages: {
                title: {
                    required: "This field is required"
                },
                start_end_time: {
                    required: "This field is required"
                }
            },
        });

        jQuery.validator.addMethod("complete_url", function(val, elem) {
            if (val.length == 0) {
            return true;
            }
            if (!/^(https?|ftp):\/\//i.test(val)) {
            val = 'http://' + val;
            $(elem).val(val);
            }
            return /^(https?|ftp):\/\/(((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&amp;'\(\)\*\+,;=]|:)*@)?(((\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5]))|((([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.)+(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.?)(:\d*)?)(\/((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&amp;'\(\)\*\+,;=]|:|@)+(\/(([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&amp;'\(\)\*\+,;=]|:|@)*)*)?)?(\?((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&amp;'\(\)\*\+,;=]|:|@)|[\uE000-\uF8FF]|\/|\?)*)?(\#((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&amp;'\(\)\*\+,;=]|:|@)|\/|\?)*)?$/i.test(val);
        });

        jQuery.validator.addMethod("numericdashe", function(value, element) {
            return this.optional(element) ||
            value.length >= 4 && /^[0-9\-\+]+$/i.test(value);
        });



        $('#start_end_time').daterangepicker({
            timePicker: true,
            autoApply: false,
            startDate: moment().startOf('hour'),
            endDate: moment().startOf('hour'),
            minDate: new Date(),
            locale: {
                format: 'MM/DD/YYYY hh:mma',
            },
            autoclose: true,
        });

         // reset edit form and validation errors and message
         $('#editModal').on('hidden.bs.modal', function () {
            $(this).find('form').trigger('reset');
            let $alerts = $('#editModal');
            $alerts.validate().resetForm();
            $alerts.find('.error').removeClass('error');
        });

        // reset add form and validation errors and message
        $('#AddModal').on('hidden.bs.modal', function () {
            $(this).find('form').trigger('reset');
            let $alerts = $('#AddModal');
            $alerts.validate().resetForm();
            $alerts.find('.error').removeClass('error');
        });

        $('.open-edit-delete').on('click',function(){
           Swal.fire({
               icon:"warning",
               title: "<?php echo e(config('globalMessages.delete_event_warning_title')); ?>",
               text: "<?php echo e(config('globalMessages.delete_event_warning_text')); ?>",
               showConfirmButton: true,
               showCancelButton: true,
               confirmButtonText: "Yes",
               cancelButtonText: "No"
           }).then((ok) => {
                if(ok['isConfirmed']){
                    let event_id = $(this).data('id');

                    $.ajax({
                        type:"post",
                        url: "<?php echo e(url(baseRedirectUrl(Request()) . '/delete-event')); ?>",
                        data:{
                            "_token": "<?php echo e(csrf_token()); ?>",
                            "event_id": event_id
                        },
                        success:function(data){
                            if(data.status == "success"){
                                Swal.fire({
                                   icon:"success",
                                   title:"Success",
                                   text: data.message
                                }).then((ok) => {
                                    if(ok){
                                        window.location.reload();
                                    }
                                });

                            }else{
                                Swal.fire({
                                    icon:"error",
                                    title:"Error",
                                    text: data.message
                                });
                            }
                        },
                        error:function(error){
                            console.log(error);
                        }
                    })
                }
           });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\Ruturajsinh\xampp\htdocs\chamber-app-ddd\resources\views/event/index.blade.php ENDPATH**/ ?>