
<?php $__env->startSection('title', 'Dashboard Statistics Overview'); ?>
<?php $__env->startSection('content'); ?>
<div class="content">
    <div class="row">
        <div class="col-md-12">
            <div class="card card-chart">
                <div class="card-header">
                    <p class="card-category">User View</p>
                </div>
                <div class="card-body">
                    <canvas id="userChartId" width="400" height="100"></canvas>
                </div>
                <div class="card-footer">

                    <hr />
                    <div class="card-stats">
                        <i class="fa fa-check"></i> Total Number of Users : <?php echo e($totaluser); ?>

                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('script-section'); ?>
    <script>
        $(document).ready(function() {

            var count = "<?php echo e($totaluser); ?>";
            var name = [];


            userChart = {

                initChartsPages: function() {
                    chartColor = "#FFFFFF";
                    var speedCanvas = document.getElementById("userChartId");
                    var dataFirst = {
                        data: [count],
                        fill: false,
                        borderColor: '#51CACF',
                        backgroundColor: 'transparent',
                        pointBorderColor: '#51CACF',
                        pointRadius: 4,
                        pointHoverRadius: 4,
                        pointBorderWidth: 8,
                    };

                    var speedData = {
                        labels: name,
                        datasets: [dataFirst]
                    };

                    var chartOptions = {
                        legend: {
                            display: false,
                            position: 'top'
                        }
                    };

                    var lineChart = new Chart(speedCanvas, {
                        type: 'line',
                        hover: false,
                        data: speedData,
                        options: chartOptions
                    });
                },
            };

            userChart.initChartsPages();
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/yaujalmy/public_html/coc/resources/views/index.blade.php ENDPATH**/ ?>