
<?php $__env->startSection('title', 'Resource Category'); ?>
<?php $__env->startSection('content'); ?>

<div class="content">
    <div class="row">
      <div class="col-md-12">
        <div class="card">
          <div class="card-header">
            <button type="button" class="btn btn-primary float-right" data-toggle="modal" data-target="#AddModal"> ADD </button>
            <h4 class="card-title"> Resource category</h4>
            <?php if($message = Session::get('success')): ?>
            <div class="alert alert-success alert-block">
              <button type="button" class="close" data-dismiss="alert">×</button>
              <strong><?php echo e($message); ?></strong>
            </div>
            <?php endif; ?>

            <?php if($message = session()->get('error')): ?>
            <div class="alert alert-danger alert-block">
              <button type="button" class="close" data-dismiss="alert">×</button>
              <strong><?php echo e($message); ?></strong>
            </div>
            <?php endif; ?>
            <?php if(count($errors) > 0): ?>
            <div class="alert alert-danger">
              <button type="button" class="close" data-dismiss="alert">×</button>
              <strong>Error!</strong> There were some problems with your input.
              <ul>
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li><?php echo e($error); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </ul>
            </div>
            <?php endif; ?>
          </div>
          <div class="card-body">
            <div class="table-responsive">
              <table class="table" id="rescategory-table">
                <thead class="text-primary">
                  <th>#</th>
                  <th>Images</th>
                  <th>Name</th>
                  <th>Order</th>
                  <th>Category Status</th>
                  <th class="text-center">Action</th>
                </thead>
                <tbody>
                  <?php $__currentLoopData = $ResourceCategory; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <tr>
                    <td><?php echo e($loop->iteration); ?></td>
                    <td>
                        <?php if($row->image_path != null && file_exists($row->image_path)): ?>
                            <img src="<?php echo e(url($row->image_path)); ?>" height="75" />
                        <?php else: ?>
                            <span>-</span>
                        <?php endif; ?>
                    </td>
                    <td><?php echo e($row->name); ?></td>
                    <td><?php echo e($row->order_num); ?></td>
                    <td><?php echo e(ucfirst($row->category_status)); ?></td>

                    <td class="text-center">
                      <div class="dropdown">
                        <button type="button" class="btn btn-primary dropdown-toggle" data-toggle="dropdown">
                          Action
                        </button>
                        <div class="dropdown-menu">
                            <a class="dropdown-item open-edit-modal"  data-id="<?php echo e($row->id); ?>" href="javascript:void(0)">Edit</a>
                            <a class="dropdown-item open-edit-delete" data-id="<?php echo e($row->id); ?>" href="javascript:void(0)">Delete</a>
                      </div>
                      </div>
                    </td>
                  </tr>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
              </table>
            </div>
          </div>
        </div>
      </div>
    </div>
</div>

<!-- Add modal -->
<?php echo $__env->make('resource-category.modal.add-resource-category-modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<!-- edit Modal -->
<?php echo $__env->make('resource-category.modal.edit-resource-category-modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('script-section'); ?>

    <script>
        $(document).ready(function() {
            $('#rescategory-table').DataTable();
        });
        $('#addform').validate({
            rules: {
                image: {
                    required: true,
                },
                name: {
                    required: true,
                },
            },
            messages: {
                image: {
                    required: "<?php echo e(config('globalMessages.required_message.image')); ?>",
                },
                name: {
                    required: "<?php echo e(config('globalMessages.required_message.name')); ?>"
                },
            },

        });

        $('.open-edit-modal').on('click',function(){
            let res_cat_id = $(this).data('id');
            $.ajax({
                method: "GET",
                url: "<?php echo e(url(  'api/'.appName(Request())  . '/get-resource-category-details')); ?>/" + res_cat_id,
                success:function(data){
                    if (data.status != 'success') {
                        Swal.fire({
                            icon:'error',
                            title:"Error!",
                            text: data.message
                        })
                        return;
                    }
                    let print_data = data.data;

                    $('.name1').val(print_data.name);
                    $('.category_status1').val(print_data.category_status);
                    $('.order_num1').val(print_data.order_num);
                    $('#res_cat_id').val(print_data.id);
                    $('#editModal').modal('show');
                },
                error:function(err){
                    console.log(err)
                }
            });

        });

        $('#editform').validate({
            rules: {
                name: {
                    required: true,
                },
            },
            messages: {
                name: {
                    required: "<?php echo e(config('globalMessages.required_message.name')); ?>"
                },
            },
        });

        // reset edit form and validation errors and message
        $('#editModal').on('hidden.bs.modal', function () {
            $(this).find('form').trigger('reset');
            let $alerts = $('#editModal');
            $alerts.validate().resetForm();
            $alerts.find('.error').removeClass('error');
        });

        // reset add form and validation errors and message
        $('#AddModal').on('hidden.bs.modal', function () {
            $(this).find('form').trigger('reset');
            let $alerts = $('#AddModal');
            $alerts.validate().resetForm();
            $alerts.find('.error').removeClass('error');
        });

        $('.open-edit-delete').on('click',function(){
           Swal.fire({
               icon:"warning",
               title: "<?php echo e(config('globalMessages.delete_resource_category_warning_title')); ?>",
               text: "<?php echo e(config('globalMessages.delete_resource_category_warning_text')); ?>",
               showConfirmButton: true,
               showCancelButton: true,
               confirmButtonText: "Yes",
               cancelButtonText: "No"
           }).then((ok) => {
                if(ok['isConfirmed']){
                    let res_cat_id = $(this).data('id');

                    $.ajax({
                        type:"post",
                        url: "<?php echo e(url('api/'.appName(Request()) .'/delete-resource-category')); ?>",
                        data:{
                            "_token": "<?php echo e(csrf_token()); ?>",
                            "res_cat_id": res_cat_id
                        },
                        success:function(data){
                            if(data.status == "success"){
                                Swal.fire({
                                   icon:"success",
                                   title:"Success",
                                   text: data.message
                                }).then((ok) => {
                                    if(ok){
                                        window.location.reload();
                                    }
                                });

                            }else{
                                Swal.fire({
                                    icon:"error",
                                    title:"Error",
                                    text: data.message
                                });
                            }
                        },
                        error:function(error){
                            console.log(error);
                        }
                    })
                }
           });
        });


    </script>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/yaujalmy/public_html/coc/resources/views/resource-category/index.blade.php ENDPATH**/ ?>