<?php $__env->startSection('content'); ?>

<div class="content">
    <div class="row">
      <div class="col-md-12">
        <div class="card">
          <div class="card-header">
            <button type="button" class="btn btn-primary float-right" onclick="clearUser();" data-toggle="modal" data-target="#AddModal"> ADD </button>
            <h4 class="card-title"> Events List</h4>
            <?php if($message = Session::get('success')): ?>
            <div class="alert alert-success alert-block">
              <button type="button" class="close" data-dismiss="alert">×</button>
              <strong><?php echo e($message); ?></strong>
            </div>
            <?php endif; ?>
            <?php if(count($errors) > 0): ?>
            <div class="alert alert-danger">
              <strong>Whoops!</strong> There were some problems with your input.
              <ul>
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li><?php echo e($error); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </ul>
            </div>
            <?php endif; ?>
          </div>

          <div class="card-body">
            <div class="table-responsive">
              <table class="table" id="example">
                <thead class=" text-primary">
                  <th>#</th>
                  <th>Images</th>
                  <th>Title</th>
                  <th>End Date</th>
                  <th>Order</th>
                  <th>Event Status</th>
                  <th class="text-center">Action</th>
                </thead>
                <tbody>
                  <?php
                  ?>
                  <?php $__currentLoopData = $events; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <tr>
                    <td><?php echo e($loop->iteration); ?></td>
                    <td><?php echo e($row->image_path); ?></td>
                    <td><?php echo e($row->title); ?></td>
                    <td><?php echo e(\Carbon\Carbon::parse($row->end_date)->format('d-M-Y')); ?></td>
                    <td><?php echo e($row->order_num); ?></td>
                    <td><?php echo e($row->event_status); ?></td>
                    <td class="text-center">
                      <div class="dropdown">
                        <button type="button" class="btn btn-primary dropdown-toggle" data-toggle="dropdown">
                          Action
                        </button>
                        <div class="dropdown-menu">
                          <a class="dropdown-item edit" data-id="<?php echo e($row->id); ?>" data-name="events">Edit</a>
                          <a class="dropdown-item delete" data-id="<?php echo e($row->id); ?>" data-name="events" href="#">Delete</a>
                        </div>
                      </div>
                    </td>
                  </tr>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
              </table>
            </div>
          </div>
        </div>
      </div>
    </div>
</div>

<!-- add Modal -->

<div class="modal fade" id="AddModal" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
      <div class="modal-content">
        <form id="addform" method="post" action="<?php echo e(url('/app/' .appName(Request()). '/add_event' )); ?>" enctype="multipart/form-data">
          <?php echo e(csrf_field()); ?>

          <div class="modal-header">
            <h5 class="modal-title" id="exampleModalLabel">Add Event</h5>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true close-btn">×</span>
            </button>
          </div>
          <div class="modal-body">
            <div class="form-group">
              <label for="addInput1">Select File * <span style="color:red;" class="err_msg"></span></label>
              <input type="file" accept="image/*" class="form-control-file my_image" name="image" id="addInput1" style="opacity: unset; position: unset">
            </div>
            <div class="form-group">
              <label for="addInput2">Title *</label>
              <textarea id="addInput2" name="title" class="form-control" cols="2"></textarea>
            </div>
            <div class="form-group">
              <label for="">Start-end Date *</label>
              <input type="text" name="start_end_time" class="form-control clsDatePicker" autocomplete="off" />
            </div>
            <div class="form-group">
              <label for="addInput4">Description</label>
              <textarea id="addInput4" name="description" class="form-control"></textarea>
            </div>
            <div class="form-group">
              <label for="addInput5">Url</label>
              <input type="url" class="form-control" name="url" id="addInput5">
            </div>
            <div class="form-group">
              <label for="addInput6">Phone</label>
              <input type="text" class="form-control" name="phone" id="addInput6" maxlength="14">
            </div>
            <div class="row">
              <div class="col-md-6">
                <div class="form-group">
                  <label for="addInput2">Event Status</label>
                  <select name="event_status" class="form-control">
                    <option value="active">Active</option>
                    <option value="inactive">Inactive</option>
                  </select>
                </div>
              </div>
              <div class="col-md-6">
                <div class="form-group">
                  <label for="addInput12">Order</label>
                  <input type="text" class="form-control" name="order_num" id="addInput12" maxlength="4" >
                </div>
              </div>
            </div>
          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-secondary close-btn" data-dismiss="modal">Close</button>
            <button type="submit" id="submit" class="btn btn-primary">Submit</button>
          </div>
        </form>
      </div>
    </div>
</div>


<!-- Edit Modal -->

<div class="modal fade" id="editModal" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
      <div class="modal-content">
        <form id="editform" method="post" action="<?php echo e(url('/app/' .appName(Request()). '/update_event' )); ?>" enctype="multipart/form-data">
          <?php echo e(csrf_field()); ?>

          <div class="modal-header">
            <h5 class="modal-title" id="exampleModalLabel">Edit Event</h5>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true close-btn">×</span>
            </button>
          </div>
          <div class="modal-body">
            <div class="form-group">
              <label for="editInput1">Select File <span style="color:red;" class="err_msg"></span></label>
              <input type="file" accept="image/*" class="form-control-file my_image" name="image" id="editInput1" style="opacity: unset; position: unset">
            </div>
            <div class="form-group">
              <label for="editInput2">Title *</label>
              <textarea id="title" name="title" class="form-control" cols="2"></textarea>
            </div>
            <div class="form-group">
              <label for="editInput3">Start-end Date *</label>
              <input type="text" name="start_end_time" id="start_end_time" class="form-control" autocomplete="off" />
            </div>
            <div class="form-group">
              <label for="editInput4">Description</label>
              <textarea id="description" name="description" class="form-control"></textarea>
            </div>
            <div class="form-group">
              <label for="editInput5">Url</label>
              <input type="url" class="form-control" name="url" id="url">
            </div>
            <div class="form-group">
              <label for="editInput6">Phone</label>
              <input type="text" class="form-control" name="phone" id="phone" maxlength="14">
            </div>
            <div class="row">
              <div class="col-md-6">
                <div class="form-group">
                  <label for="addInput2">Event Status</label>
                  <select name="event_status" id="event_status" class="form-control">
                    <option value="active">Active</option>
                    <option value="inactive">Inactive</option>
                  </select>
                </div>
              </div>
              <div class="col-md-6">
                <div class="form-group">
                  <label for="editInput12">Order</label>
                  <input type="text" class="form-control" name="order_num" id="order_num" maxlength="4" >
                </div>
              </div>
            </div>
          </div>
          <input type="hidden" name="event_id" id="event_id">
          <div class="modal-footer">
            <button type="button" class="btn btn-secondary close-btn" data-dismiss="modal">Close</button>
            <button type="submit" class="btn btn-primary">Save changes</button>
          </div>
        </form>
      </div>
    </div>
</div>

<script>
    $(document).on('click', '.edit', function() {
        $("#editform").find('.has-error').removeClass("has-error");
        $("#editform").find('.has-success').removeClass("has-success");
        $("#editform").find('.err_msg').text("");
        $('#editform').find('.form-control-feedback').remove();
        var id = $(this).data('id');
        var name = $(this).data('name');
        $.ajax({
        type: 'POST',
        url: "<?php echo e(url('/app/' .appName(Request()). '/getdata' )); ?>",
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        data: {
            'id': id,
            'name': name
        },
        success: function(data) {
            if (data) {
            $('#text1').val(data.text1);
            $('input[name="start_end_time"]').daterangepicker({
                timePicker: true,
                startDate: moment(data.start_date).format("MM/DD/YYYY hh:mma"),
                endDate: moment(data.end_date).format("MM/DD/YYYY hh:mma"),
                minDate: new Date(),
                locale: {
                format: 'MM/DD/YYYY hh:mma'
                }
            });
            $('input[name="start_end_time"]').on('hide.daterangepicker', function(ev, picker) {
                if (picker.startDate.format('MM/DD/YYYY') == picker.endDate.format('MM/DD/YYYY')) {
                var from = picker.startDate.format('hh:mma');
                var to = picker.endDate.format('hh:mma');
                if (moment(from, 'hh:mm a') > moment(to, 'hh:mm a')) {
                    $('input[name="start_end_time"]').val('');
                }
                }
                if (picker.startDate.format('MM/DD/YYYY hh:mma') == picker.endDate.format('MM/DD/YYYY hh:mma')) {
                $('input[name="start_end_time"]').closest("div").addClass('has-error');
                $('input[name="start_end_time"]').val('');
                } else {
                $('input[name="start_end_time"]').closest("div").removeClass('has-error');
                }
            });
            $('#text2').daterangepicker('setDate', data.text2);
            $('#title').val(data.title);
            $('#description').val(data.description);
            $('#url').val(data.url);
            $('#phone').val(data.phone);
            $('#order_num').val(data.order_num);
            $('#event_status').val(data.event_status);
            $('#event_id').val(data.id);
            $('#editModal').modal('show');
            }
        }
        });
    });

    $('#addform').validate({


        rules: {
            image: {
                required: true,
            },
            title: {
                required: true,
            },
            start_end_time: {
                required: true,
            },
            phone: {
                maxlength: 14,
                numericdashe: true
            },
            url: {
                complete_url: true
            }
        },

        messages: {
            image: {
                required: "This field is required",
            },
            title: {
                required: "This field is required"
            },
            start_end_time: {
                required: "This field is required"
            }
        },
        errorPlacement: function(error, element) {
        element.closest("div").addClass('has-error');
        },

        success: function(error, element) {
        $(element).closest("div").removeClass('has-error');
        }
    });

    $('#editform').validate({
        rules: {
            title: {
                required: true,
            },
            start_end_time: {
                required: true
            },

            phone: {
                maxlength: 14,
                numericdashe: true
            },
            url: {
                complete_url: true
            }
        },

        messages: {
            title: {
                required: "This field is required"
            },
            start_end_time: {
                required: "This field is required"
            }
        },

        errorPlacement: function(error, element) {
            element.closest("div").addClass('has-error');
        },
        success: function(error, element) {
            $(element).closest("div").removeClass('has-error');
        }
    });

    jQuery.validator.addMethod("complete_url", function(val, elem) {

        if (val.length == 0) {
        return true;
        }
        if (!/^(https?|ftp):\/\//i.test(val)) {
        val = 'http://' + val;
        $(elem).val(val);
        }
        return /^(https?|ftp):\/\/(((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&amp;'\(\)\*\+,;=]|:)*@)?(((\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5]))|((([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.)+(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.?)(:\d*)?)(\/((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&amp;'\(\)\*\+,;=]|:|@)+(\/(([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&amp;'\(\)\*\+,;=]|:|@)*)*)?)?(\?((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&amp;'\(\)\*\+,;=]|:|@)|[\uE000-\uF8FF]|\/|\?)*)?(\#((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&amp;'\(\)\*\+,;=]|:|@)|\/|\?)*)?$/i.test(val);

    });

    jQuery.validator.addMethod("numericdashe", function(value, element) {
        return this.optional(element) ||
        value.length >= 4 && /^[0-9\-\+]+$/i.test(value);
    });


    $(function() {

        $('input[name="start_end_time"]').daterangepicker({
        timePicker: true,
        autoApply: false,
        autoUpdateInput: false,
        startDate: moment().startOf('hour'),
        endDate: moment().startOf('hour'),
        minDate: new Date(),
        locale: {
            format: 'MM/DD/YYYY hh:mma',
        },
        autoclose: true,
        });

        $('input[name="start_end_time"]').on('hide.daterangepicker', function(ev, picker) {

            if (picker.startDate.format('MM/DD/YYYY') == picker.endDate.format('MM/DD/YYYY')) {
                var from = picker.startDate.format('hh:mma');
                var to = picker.endDate.format('hh:mma');
                if (moment(from, 'hh:mm a') > moment(to, 'hh:mm a')) {
                $('input[name="start_end_time"]').val('');
                }
            }
            if (picker.startDate.format('MM/DD/YYYY hh:mma') == picker.endDate.format('MM/DD/YYYY hh:mma')) {
                $('input[name="start_end_time"]').closest("div").addClass('has-error');
                $('input[name="start_end_time"]').val('');
            } else {
                $('input[name="start_end_time"]').closest("div").removeClass('has-error');
            }
        });
    });

    // delete
    $(document).on('click', '.delete', function() {
        if (confirm("Are you sure You want to delete it?")) {
          var id = $(this).data('id');
          var name = $(this).data('name');
          $.ajax({
            type: 'POST',
            url: "<?php echo e(url('/app/' .appName(Request()). '/eventdelete' )); ?>",
            headers: {
              'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            data: {
              'id': id,
              'name': name
            },
            success: function(data) {
              if (data) {
                alert("Delete successfully.");
                window.location.reload();
              } else {
                alert("Somthing went wrong.");
              }
            }
          });
        }
    });
</script>

<style>
    .modal-body {
      position: relative;
      -ms-flex: 1 1 auto;
      flex: 1 1 auto;
      padding: 1rem;
      overflow-y: auto;
      height: 750px;
    }
</style>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\chamber-ddd\resources\views/event/index.blade.php ENDPATH**/ ?>